/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.entity.DepthVaseBlockEntity;
import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.bigdious.risus.entity.projectile.ThrownAxe;
import com.bigdious.risus.init.RisusBlockEntities;
import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.init.RisusParticles;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DepthVaseBlock
extends BaseEntityBlock
implements SimpleMultiloggedBlock {
    public static final MapCodec<DepthVaseBlock> CODEC = DepthVaseBlock.simpleCodec(DepthVaseBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;
    protected static final VoxelShape BOUNDING_BOX = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);

    public DepthVaseBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, FLUIDLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())));
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
            accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return BOUNDING_BOX;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity $$8 = level.getBlockEntity(pos);
        if ($$8 instanceof DepthVaseBlockEntity) {
            int i;
            DepthVaseBlockEntity depthVase = (DepthVaseBlockEntity)$$8;
            if (hand != InteractionHand.MAIN_HAND) {
                player.playSound(SoundEvents.DECORATED_POT_INSERT_FAIL);
                depthVase.wobble(DepthVaseBlockEntity.DepthWobbleStyle.NEGATIVE);
                return ItemInteractionResult.FAIL;
            }
            if (player.getMainHandItem().is(RisusItems.RESEARCHERS_NOTES)) {
                player.sendSystemMessage((Component)Component.literal((String)(depthVase.depthToSlotRatio + " Slots")));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!player.getMainHandItem().isEmpty() && !player.isCrouching()) {
                for (i = 0; i < depthVase.depthToSlotRatio + 1; ++i) {
                    if (i == depthVase.depthToSlotRatio) {
                        player.playSound(SoundEvents.DECORATED_POT_INSERT_FAIL);
                        depthVase.wobble(DepthVaseBlockEntity.DepthWobbleStyle.NEGATIVE);
                        return ItemInteractionResult.FAIL;
                    }
                    if (depthVase.canMergeItems(player.getMainHandItem(), depthVase.getInputItem(i)) && depthVase.getInputItem(i).getCount() < depthVase.getInputItem(i).getMaxStackSize()) {
                        if (depthVase.getInputItem(i).getCount() + player.getMainHandItem().getCount() <= depthVase.getInputItem(i).getMaxStackSize()) {
                            depthVase.getInputItem(i).grow(player.getMainHandItem().getCount());
                            player.getMainHandItem().shrink(player.getMainHandItem().getCount());
                            depthVase.wobble(DepthVaseBlockEntity.DepthWobbleStyle.POSITIVE);
                            level.playSound(null, (Entity)player, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 1.2f);
                            if (level instanceof ServerLevel) {
                                ServerLevel serverlevel = (ServerLevel)level;
                                serverlevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                            }
                            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                        }
                        player.getMainHandItem().shrink(depthVase.getInputItem(i).getMaxStackSize() - depthVase.getInputItem(i).getCount());
                        depthVase.getInputItem(i).grow(depthVase.getInputItem(i).getMaxStackSize() - depthVase.getInputItem(i).getCount());
                        depthVase.wobble(DepthVaseBlockEntity.DepthWobbleStyle.POSITIVE);
                        level.playSound(null, (Entity)player, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 1.2f);
                        if (level instanceof ServerLevel) {
                            ServerLevel serverlevel = (ServerLevel)level;
                            serverlevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                        }
                        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                    }
                    if (!depthVase.getInputItem(i).isEmpty()) continue;
                    depthVase.setInputItem(i, player.getInventory().removeItem(player.getInventory().selected, 1));
                    depthVase.wobble(DepthVaseBlockEntity.DepthWobbleStyle.POSITIVE);
                    level.playSound(null, (Entity)player, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 1.2f);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverlevel = (ServerLevel)level;
                        serverlevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
            if (player.getMainHandItem().isEmpty() && !player.isCrouching()) {
                for (i = depthVase.depthToSlotRatio - 1; i >= 0; --i) {
                    if (depthVase.getInputItem(i).isEmpty()) continue;
                    ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), depthVase.getInputItem(i));
                    level.addFreshEntity((Entity)item);
                    depthVase.setInputItem(i, ItemStack.EMPTY);
                    depthVase.wobble(DepthVaseBlockEntity.DepthWobbleStyle.POSITIVE);
                    level.playSound(null, (Entity)player, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 1.2f);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverlevel = (ServerLevel)level;
                        serverlevel.sendParticles((ParticleOptions)((SimpleParticleType)RisusParticles.RISUS_SOUL_PARTICLE.get()), (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return ItemInteractionResult.FAIL;
    }

    public void onProjectileHit(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        BlockPos blockpos = pHit.getBlockPos();
        if (!pLevel.isClientSide && pProjectile.mayInteract(pLevel, blockpos) && pProjectile instanceof ThrownTrident && pProjectile.getDeltaMovement().length() > 0.6) {
            pLevel.destroyBlock(blockpos, true);
        }
        if (!pLevel.isClientSide && pProjectile.mayInteract(pLevel, blockpos) && pProjectile instanceof ThrownAxe && pProjectile.getDeltaMovement().length() > 0.6) {
            pLevel.destroyBlock(blockpos, true);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof Container) {
                Container container = (Container)blockentity;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)container);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, moving);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DepthVaseBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return DepthVaseBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RisusBlockEntities.DEPTH_VASE.get()), DepthVaseBlockEntity::tick);
    }
}

