/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RegenRoseBlock
extends FlowerBlock {
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0);

    public RegenRoseBlock(BlockBehaviour.Properties properties) {
        super(MobEffects.REGENERATION, 1.0f, properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return type == PathComputationType.AIR && !this.hasCollision || super.isPathfindable(state, type);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        LivingEntity living;
        if (!level.isClientSide() && entity instanceof LivingEntity && (living = (LivingEntity)entity).isAlive() && (living.tickCount % 50 == 0 || !living.hasEffect(MobEffects.REGENERATION))) {
            living.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100));
        }
    }

    public float getShadeBrightness(BlockState state, BlockGetter getter, BlockPos pos) {
        return 1.0f;
    }
}

