/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RisusWallBlock
extends WallBlock
implements SimpleMultiloggedBlock {
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;

    public RisusWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)UP, (Comparable)Boolean.valueOf(true))).setValue((Property)NORTH_WALL, (Comparable)WallSide.NONE)).setValue((Property)EAST_WALL, (Comparable)WallSide.NONE)).setValue((Property)SOUTH_WALL, (Comparable)WallSide.NONE)).setValue((Property)WEST_WALL, (Comparable)WallSide.NONE)).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY)));
    }

    public Map<BlockState, VoxelShape> makeShapes(float pWidth, float pDepth, float pWallPostHeight, float pWallMinY, float pWallLowHeight, float pWallTallHeight) {
        float f = 8.0f - pWidth;
        float f1 = 8.0f + pWidth;
        float f2 = 8.0f - pDepth;
        float f3 = 8.0f + pDepth;
        VoxelShape voxelshape = Block.box((double)f, (double)0.0, (double)f, (double)f1, (double)pWallPostHeight, (double)f1);
        VoxelShape voxelshape1 = Block.box((double)f2, (double)pWallMinY, (double)0.0, (double)f3, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape2 = Block.box((double)f2, (double)pWallMinY, (double)f2, (double)f3, (double)pWallLowHeight, (double)16.0);
        VoxelShape voxelshape3 = Block.box((double)0.0, (double)pWallMinY, (double)f2, (double)f3, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape4 = Block.box((double)f2, (double)pWallMinY, (double)f2, (double)16.0, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape5 = Block.box((double)f2, (double)pWallMinY, (double)0.0, (double)f3, (double)pWallTallHeight, (double)f3);
        VoxelShape voxelshape6 = Block.box((double)f2, (double)pWallMinY, (double)f2, (double)f3, (double)pWallTallHeight, (double)16.0);
        VoxelShape voxelshape7 = Block.box((double)0.0, (double)pWallMinY, (double)f2, (double)f3, (double)pWallTallHeight, (double)f3);
        VoxelShape voxelshape8 = Block.box((double)f2, (double)pWallMinY, (double)f2, (double)16.0, (double)pWallTallHeight, (double)f3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean obool : UP.getPossibleValues()) {
            for (WallSide wallside : EAST_WALL.getPossibleValues()) {
                for (WallSide wallside1 : NORTH_WALL.getPossibleValues()) {
                    for (WallSide wallside2 : WEST_WALL.getPossibleValues()) {
                        for (WallSide wallside3 : SOUTH_WALL.getPossibleValues()) {
                            VoxelShape voxelshape9 = Shapes.empty();
                            voxelshape9 = RisusWallBlock.applyWallShape((VoxelShape)voxelshape9, (WallSide)wallside, (VoxelShape)voxelshape4, (VoxelShape)voxelshape8);
                            voxelshape9 = RisusWallBlock.applyWallShape((VoxelShape)voxelshape9, (WallSide)wallside2, (VoxelShape)voxelshape3, (VoxelShape)voxelshape7);
                            voxelshape9 = RisusWallBlock.applyWallShape((VoxelShape)voxelshape9, (WallSide)wallside1, (VoxelShape)voxelshape1, (VoxelShape)voxelshape5);
                            voxelshape9 = RisusWallBlock.applyWallShape((VoxelShape)voxelshape9, (WallSide)wallside3, (VoxelShape)voxelshape2, (VoxelShape)voxelshape6);
                            if (obool.booleanValue()) {
                                voxelshape9 = Shapes.or((VoxelShape)voxelshape9, (VoxelShape)voxelshape);
                            }
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)obool)).setValue((Property)EAST_WALL, (Comparable)wallside)).setValue((Property)WEST_WALL, (Comparable)wallside2)).setValue((Property)NORTH_WALL, (Comparable)wallside1)).setValue((Property)SOUTH_WALL, (Comparable)wallside3);
                            builder.put((Object)((BlockState)((BlockState)blockstate.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)voxelshape9);
                            builder.put((Object)((BlockState)((BlockState)blockstate.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.LAVA))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)voxelshape9);
                            builder.put((Object)((BlockState)((BlockState)blockstate.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.WATER))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)voxelshape9);
                            builder.put((Object)((BlockState)((BlockState)blockstate.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.BLOOD))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)voxelshape9);
                            builder.put((Object)((BlockState)((BlockState)blockstate.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)voxelshape9);
                            builder.put((Object)((BlockState)((BlockState)blockstate.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.LAVA))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)voxelshape9);
                            builder.put((Object)((BlockState)((BlockState)blockstate.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.WATER))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)voxelshape9);
                            builder.put((Object)((BlockState)((BlockState)blockstate.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.BLOOD))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)voxelshape9);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level levelreader = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        BlockPos blockpos1 = blockpos.north();
        BlockPos blockpos2 = blockpos.east();
        BlockPos blockpos3 = blockpos.south();
        BlockPos blockpos4 = blockpos.west();
        BlockPos blockpos5 = blockpos.above();
        BlockState blockstate = levelreader.getBlockState(blockpos1);
        BlockState blockstate1 = levelreader.getBlockState(blockpos2);
        BlockState blockstate2 = levelreader.getBlockState(blockpos3);
        BlockState blockstate3 = levelreader.getBlockState(blockpos4);
        BlockState blockstate4 = levelreader.getBlockState(blockpos5);
        boolean flag = this.connectsTo(blockstate, blockstate.isFaceSturdy((BlockGetter)levelreader, blockpos1, Direction.SOUTH), Direction.SOUTH);
        boolean flag1 = this.connectsTo(blockstate1, blockstate1.isFaceSturdy((BlockGetter)levelreader, blockpos2, Direction.WEST), Direction.WEST);
        boolean flag2 = this.connectsTo(blockstate2, blockstate2.isFaceSturdy((BlockGetter)levelreader, blockpos3, Direction.NORTH), Direction.NORTH);
        boolean flag3 = this.connectsTo(blockstate3, blockstate3.isFaceSturdy((BlockGetter)levelreader, blockpos4, Direction.EAST), Direction.EAST);
        BlockState blockstate5 = (BlockState)this.defaultBlockState().setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())));
        return this.updateShape((LevelReader)levelreader, blockstate5, blockpos5, blockstate4, flag, flag1, flag2, flag3);
    }

    private boolean connectsTo(BlockState p_58021_, boolean p_58022_, Direction p_58023_) {
        Block block = p_58021_.getBlock();
        boolean flag = block instanceof FenceGateBlock && FenceGateBlock.connectsToDirection((BlockState)p_58021_, (Direction)p_58023_);
        return p_58021_.is(BlockTags.WALLS) || !RisusWallBlock.isExceptionForConnection((BlockState)p_58021_) && p_58022_ || block instanceof IronBarsBlock || flag;
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
            accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
        }
        if (direction == Direction.DOWN) {
            return state;
        }
        return direction == Direction.UP ? this.topUpdate((LevelReader)accessor, state, neighborPos, neighborState) : this.sideUpdate((LevelReader)accessor, pos, state, neighborPos, neighborState, direction);
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return pState.getValue(FLUIDLOGGED) == SimpleMultiloggedBlock.MultiloggingEnum.EMPTY;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL, WATERLOGGED, FLUIDLOGGED});
    }

    @Override
    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter getter, BlockPos pos, BlockState state, Fluid fluid) {
        return SimpleMultiloggedBlock.super.canPlaceLiquid(player, getter, pos, state, fluid);
    }

    @Override
    public ItemStack pickupBlock(@Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        return SimpleMultiloggedBlock.super.pickupBlock(pPlayer, pLevel, pPos, pState);
    }

    @Override
    public Optional<SoundEvent> getPickupSound() {
        return Optional.empty();
    }

    @Override
    public boolean placeLiquid(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        return SimpleMultiloggedBlock.super.placeLiquid(pLevel, pPos, pState, pFluidState);
    }
}

