/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.bigdious.risus.blocks.plantblocks.RisusGrowingPlantBodyBlock;
import com.bigdious.risus.blocks.plantblocks.RisusGrowingPlantHeadBlock;
import com.bigdious.risus.init.RisusBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VeinsBlock
extends RisusGrowingPlantBodyBlock
implements SimpleMultiloggedBlock {
    public static final MapCodec<VeinsBlock> CODEC = VeinsBlock.simpleCodec(VeinsBlock::new);
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;

    public MapCodec<VeinsBlock> codec() {
        return CODEC;
    }

    public VeinsBlock(BlockBehaviour.Properties p_154975_) {
        super(p_154975_, Direction.DOWN, SHAPE, false);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY)));
    }

    @Override
    protected RisusGrowingPlantHeadBlock getHeadBlock() {
        return (RisusGrowingPlantHeadBlock)RisusBlocks.VEINS_END.get();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FLUIDLOGGED});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos().relative(this.growthDirection));
        return !blockstate.is((Block)this.getHeadBlock()) && !blockstate.is(this.getBodyBlock()) ? this.getStateForPlacement((LevelAccessor)context.getLevel()) : (BlockState)this.getBodyBlock().defaultBlockState().setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())));
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (direction == this.growthDirection.getOpposite() && !state.canSurvive((LevelReader)accessor, pos)) {
            accessor.scheduleTick(pos, (Block)this, 1);
        }
        RisusGrowingPlantHeadBlock growingplantheadblock = this.getHeadBlock();
        if (direction == this.growthDirection && !neighborState.is((Block)this) && !neighborState.is((Block)growingplantheadblock)) {
            return this.updateHeadAfterConvertedFromBody(state, (BlockState)growingplantheadblock.getStateForPlacement(accessor).setValue(FLUIDLOGGED, (Comparable)((Object)((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))))));
        }
        if (this.scheduleFluidTicks && state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
            accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
    }
}

