/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.bigdious.risus.blocks.plantblocks.RisusGrowingPlantHeadBlock;
import com.bigdious.risus.blocks.plantblocks.RisusVines;
import com.bigdious.risus.init.RisusBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;

public class VeinsEndBlock
extends RisusGrowingPlantHeadBlock
implements SimpleMultiloggedBlock {
    public static final MapCodec<VeinsEndBlock> CODEC = VeinsEndBlock.simpleCodec(VeinsEndBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;

    public MapCodec<VeinsEndBlock> codec() {
        return CODEC;
    }

    public VeinsEndBlock(BlockBehaviour.Properties p_154966_) {
        super(p_154966_, Direction.DOWN, SHAPE, true, 0.1);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY)));
    }

    @Override
    protected int getBlocksToGrowWhenOrganicMattered(RandomSource p_222680_) {
        return RisusVines.getBlocksToGrowWhenOrganicMattered(p_222680_);
    }

    @Override
    protected Block getBodyBlock() {
        return (Block)RisusBlocks.VEINS.get();
    }

    @Override
    protected boolean canGrowInto(BlockState p_154971_) {
        return RisusVines.isValidGrowthState(p_154971_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FLUIDLOGGED});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())))).setValue((Property)AGE, (Comparable)Integer.valueOf(context.getLevel().getRandom().nextInt(25)));
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (direction == this.growthDirection.getOpposite() && !state.canSurvive((LevelReader)accessor, pos)) {
            accessor.scheduleTick(pos, (Block)this, 1);
        }
        if (direction != this.growthDirection || !neighborState.is((Block)this) && !neighborState.is(this.getBodyBlock())) {
            if (this.scheduleFluidTicks && state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
                accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
            }
            return super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
        }
        return this.updateBodyAfterConvertedFromHead(state, (BlockState)this.getBodyBlock().defaultBlockState().setValue(FLUIDLOGGED, (Comparable)((Object)((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))))));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack held = player.getItemInHand(hand);
        if (held.is(Tags.Items.TOOLS_SHEAR) && (Integer)state.getValue((Property)AGE) < 25) {
            level.setBlock(pos, (BlockState)((RisusGrowingPlantHeadBlock)RisusBlocks.VEINS_END.get()).defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(25)), 11);
            level.playSound(player, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS);
        }
        return ItemInteractionResult.FAIL;
    }
}

