/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks.entity;

import com.bigdious.risus.init.RisusBlockEntities;
import com.bigdious.risus.inventory.DepthVaseMenu;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class DepthVaseBlockEntity
extends RandomizableContainerBlockEntity {
    public final int depthToSlotRatio = (int)Math.round(81.0 - (double)(this.getBlockPos().getY() + 64) / 4.74);
    public static final int EVENT_POT_WOBBLES = 1;
    public long wobbleStartedAtTick;
    @Nullable
    public DepthWobbleStyle lastWobbleStyle;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)this.depthToSlotRatio, (Object)ItemStack.EMPTY);

    public DepthVaseBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RisusBlockEntities.DEPTH_VASE.get(), pPos, pBlockState);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        if (!this.trySaveLootTable(pTag)) {
            ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        }
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(pTag)) {
            ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        }
    }

    public int getContainerSize() {
        return this.depthToSlotRatio;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
        this.items = pItems;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.risus.depth_vase");
    }

    protected AbstractContainerMenu createMenu(int pId, Inventory pPlayer) {
        return new DepthVaseMenu(pId, pPlayer);
    }

    public static <E extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, E e) {
    }

    public void setItem(int pIndex, ItemStack pStack) {
        this.unpackLootTable(null);
        this.getItems().set(pIndex, (Object)pStack);
        if (pStack.getCount() > this.getMaxStackSize()) {
            pStack.setCount(this.getMaxStackSize());
        }
    }

    public boolean canMergeItems(ItemStack oldStack, ItemStack newStack) {
        return ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    public void setInputItem(int slot, ItemStack item) {
        this.setItem(slot, item);
        this.wobble(DepthWobbleStyle.POSITIVE);
        this.setChanged();
    }

    @Nullable
    public ItemStack getInputItem(int slot) {
        return this.getItem(slot);
    }

    public void wobble(DepthWobbleStyle pStyle) {
        if (this.level != null && !this.level.isClientSide()) {
            this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 1, pStyle.ordinal());
        }
    }

    public boolean triggerEvent(int pId, int pType) {
        if (this.level != null && pId == 1 && pType >= 0 && pType < DepthWobbleStyle.values().length) {
            this.wobbleStartedAtTick = this.level.getGameTime();
            this.lastWobbleStyle = DepthWobbleStyle.values()[pType];
            return true;
        }
        return super.triggerEvent(pId, pType);
    }

    public static enum DepthWobbleStyle {
        POSITIVE(7),
        NEGATIVE(10);

        public final int duration;

        private DepthWobbleStyle(int p_305780_) {
            this.duration = p_305780_;
        }
    }
}

