/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks.entity;

import com.bigdious.risus.blocks.DisplayNotchBlock;
import com.bigdious.risus.init.RisusBlockEntities;
import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.ticks.ContainerSingleItem;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class DisplayNotchBlockEntity
extends BlockEntity
implements ContainerSingleItem.BlockContainerSingleItem {
    protected ItemStack item = ItemStack.EMPTY;
    public boolean glowing;
    public boolean stand;
    public boolean rotate;
    public int ticks;

    public DisplayNotchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RisusBlockEntities.DISPLAY_NOTCH.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DisplayNotchBlockEntity entity) {
        entity.ticks = entity.rotate ? ++entity.ticks : 0;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.item != null && !this.item.isEmpty()) {
            tag.put("item", this.item.save(registries));
        }
        tag.putInt("ticks", this.ticks);
        tag.putBoolean("rotate", this.rotate);
        tag.putBoolean("glowing", this.glowing);
        tag.putBoolean("stand", this.stand);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.item = tag.contains("item") ? (ItemStack)ItemStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("item")).mapOrElse(Function.identity(), e -> ItemStack.EMPTY) : ItemStack.EMPTY;
        this.ticks = tag.getInt("ticks");
        this.rotate = tag.getBoolean("rotate");
        this.glowing = tag.getBoolean("glowing");
        this.stand = tag.getBoolean("stand");
        super.loadAdditional(tag, registries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public ItemStack getTheItem() {
        return this.item;
    }

    public void setTheItem(ItemStack item) {
        this.item = item;
        this.setChanged();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public BlockEntity getContainerBlockEntity() {
        return this;
    }

    public boolean handleBEInteractions(ItemStack stack, Level level, BlockPos pos, BlockState state) {
        if (stack.is(Items.GLOW_INK_SAC) && !this.glowing) {
            this.glowing = true;
            this.setChanged();
            return true;
        }
        if (stack.is(Tags.Items.DYES)) {
            DyeColor color = DyeColor.getColor((ItemStack)stack);
            if (color != null) {
                BlockEntity oldBe = level.getBlockEntity(pos);
                level.setBlockAndUpdate(pos, ((Block)DisplayNotchBlock.NOTCH_BY_DYE.get(color).get()).withPropertiesOf(state));
                level.setBlockEntity(oldBe);
                this.setChanged();
                return true;
            }
        } else {
            if (stack.is(Items.REDSTONE_TORCH)) {
                this.rotate = !this.rotate;
                this.setChanged();
                return true;
            }
            if (stack.is(ItemTags.AXES)) {
                this.stand = !this.stand;
                this.setChanged();
                return true;
            }
        }
        return false;
    }
}

