/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks.entity;

import com.bigdious.risus.blocks.CrystallizedBondsBlock;
import com.bigdious.risus.blocks.PoppingBondknotBlock;
import com.bigdious.risus.init.RisusBlockEntities;
import com.bigdious.risus.init.RisusBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PoppingBondknotBlockEntity
extends BlockEntity {
    private int popTimer = 0;
    private boolean popping = false;
    public final Direction popDir;
    private int secondTicker;

    public PoppingBondknotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RisusBlockEntities.POPPING_BONDKNOT.get(), pos, state);
        this.popDir = (Direction)state.getValue(PoppingBondknotBlock.POP_SIDE);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PoppingBondknotBlockEntity te) {
        if (te.popDir != null && !level.getBlockState(pos.relative((Direction)state.getValue(PoppingBondknotBlock.POP_SIDE), 1)).is(RisusBlocks.CRYSTALLIZED_BONDS)) {
            if (!te.popping && te.secondTicker++ >= 20) {
                if (level.getRandom().nextInt(500) == 0) {
                    te.popping = true;
                }
                te.secondTicker = 0;
            }
            if (level.getBlockState(pos.relative(te.popDir)).canBeReplaced() && te.popping) {
                te.particles((ServerLevel)level);
                ++te.popTimer;
            }
            if (level.getBlockState(pos.relative(te.popDir)).canBeReplaced() && te.popTimer > 5) {
                te.createCrystal(level);
                te.popping = false;
                te.popTimer = 0;
            }
        }
    }

    private void particles(ServerLevel level) {
        if (this.popDir != null) {
            BlockPos crystal = this.getBlockPos().relative(this.popDir);
            level.sendParticles((ParticleOptions)DustParticleOptions.REDSTONE, (double)((float)crystal.getX() - (float)this.popDir.getStepX() * 0.5f + 0.5f), (double)((float)crystal.getY() - (float)this.popDir.getStepY() * 0.5f + 0.5f), (double)((float)crystal.getZ() - (float)this.popDir.getStepZ() * 0.5f + 0.5f), 5, 0.1, 0.1, 0.1, 0.0);
        }
    }

    private void createCrystal(Level level) {
        if (this.popDir != null) {
            level.setBlockAndUpdate(this.getBlockPos().relative(this.popDir), (BlockState)((Block)RisusBlocks.CRYSTALLIZED_BONDS.get()).defaultBlockState().setValue((Property)CrystallizedBondsBlock.FACING, (Comparable)this.popDir));
            level.playSound(null, this.getBlockPos().relative(this.popDir), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

