/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client;

import com.bigdious.risus.Risus;
import com.bigdious.risus.client.MawGutsScreen;
import com.bigdious.risus.client.RisusModelLayers;
import com.bigdious.risus.client.model.block.BloodWyrmHeadModel;
import com.bigdious.risus.client.model.entity.AngelModel;
import com.bigdious.risus.client.model.entity.BabySpiderModel;
import com.bigdious.risus.client.model.entity.BloodSlashModel;
import com.bigdious.risus.client.model.entity.GutsBoatModel;
import com.bigdious.risus.client.model.entity.HolderModel;
import com.bigdious.risus.client.model.entity.LickerModel;
import com.bigdious.risus.client.model.entity.LoverModel;
import com.bigdious.risus.client.model.entity.MawModel;
import com.bigdious.risus.client.model.entity.Memory1Model;
import com.bigdious.risus.client.model.entity.QuestionMarkModel;
import com.bigdious.risus.client.model.entity.SingerModel;
import com.bigdious.risus.client.model.entity.StalkerModel;
import com.bigdious.risus.client.model.entity.ThrownAxeModel;
import com.bigdious.risus.client.model.entity.WeaverModel;
import com.bigdious.risus.client.particle.AlterationFinishedParticle;
import com.bigdious.risus.client.particle.AlterationParticle;
import com.bigdious.risus.client.particle.BlockOrganicParticle;
import com.bigdious.risus.client.particle.BloodBitParticle;
import com.bigdious.risus.client.particle.BloodParticle;
import com.bigdious.risus.client.particle.FieryOrganicParticle;
import com.bigdious.risus.client.particle.JoyParticle;
import com.bigdious.risus.client.particle.RisusSoulParticle;
import com.bigdious.risus.client.particle.ToothicalParticle;
import com.bigdious.risus.client.render.AlterationCatalystRenderer;
import com.bigdious.risus.client.render.AngelRenderer;
import com.bigdious.risus.client.render.BabySpiderRenderer;
import com.bigdious.risus.client.render.BloodSlashRenderer;
import com.bigdious.risus.client.render.BloodwyrmBreathEntityRenderer;
import com.bigdious.risus.client.render.DepthVaseRenderer;
import com.bigdious.risus.client.render.DisplayNotchRenderer;
import com.bigdious.risus.client.render.HolderRenderer;
import com.bigdious.risus.client.render.LickerRenderer;
import com.bigdious.risus.client.render.LoverRenderer;
import com.bigdious.risus.client.render.MawRenderer;
import com.bigdious.risus.client.render.Memory1Renderer;
import com.bigdious.risus.client.render.QuestionMarkRenderer;
import com.bigdious.risus.client.render.RisusBoatRenderer;
import com.bigdious.risus.client.render.RisusSpawnerRenderer;
import com.bigdious.risus.client.render.SingerRenderer;
import com.bigdious.risus.client.render.StalkerRenderer;
import com.bigdious.risus.client.render.ThrownAxeRenderer;
import com.bigdious.risus.client.render.WeaverRenderer;
import com.bigdious.risus.client.render.layer.AngelWingsLayer;
import com.bigdious.risus.entity.RisusBoat;
import com.bigdious.risus.init.RisusBlockEntities;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusEntities;
import com.bigdious.risus.init.RisusFluids;
import com.bigdious.risus.init.RisusMenuType;
import com.bigdious.risus.init.RisusMobEffects;
import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.init.RisusTags;
import com.bigdious.risus.util.RisusSkullType;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.CampfireRenderer;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterNamedRenderTypesEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerHeartTypeEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class RisusClientEvents {
    private static final RenderType MONOLITH_PORTAL = RenderType.create((String)"risus:monolith_portal", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateAccessor.getEndPortal()).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.builder().add(TheEndPortalRenderer.END_SKY_LOCATION, false, false).add(TheEndPortalRenderer.END_PORTAL_LOCATION, false, false).build()).createCompositeState(false));

    public static void initEvents(IEventBus bus) {
        bus.addListener(RisusClientEvents::clientSetup);
        bus.addListener(RisusClientEvents::registerParticleFactories);
        bus.addListener(RisusClientEvents::registerEntityLayers);
        bus.addListener(RisusClientEvents::registerSkullModel);
        bus.addListener(RisusClientEvents::registerOverlays);
        bus.addListener(RisusClientEvents::registerEntityRenderers);
        bus.addListener(RisusClientEvents::registerScreens);
        bus.addListener(RisusClientEvents::registerBlockColors);
        bus.addListener(RisusClientEvents::registerItemColors);
        bus.addListener(RisusClientEvents::registerClientExtensions);
        bus.addListener(EntityRenderersEvent.AddLayers.class, RisusClientEvents::attachRenderLayers);
        NeoForge.EVENT_BUS.addListener(RisusClientEvents::killScreenWithAmnesia);
        NeoForge.EVENT_BUS.addListener(RisusClientEvents::killHandWithAmnesia);
        NeoForge.EVENT_BUS.addListener(RisusClientEvents::renderExburnHearts);
        NeoForge.EVENT_BUS.addListener(RisusClientEvents::renderDeathHearts);
        NeoForge.EVENT_BUS.addListener(RisusClientEvents::renderBloodcloggedHearts);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)RisusFluids.SOURCE_BLOOD.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)RisusFluids.FLOWING_BLOOD.get()), (RenderType)RenderType.translucent());
        event.enqueueWork(() -> {
            SkullBlockRenderer.SKIN_BY_TYPE.put(RisusSkullType.BLOODWYRM, Risus.prefix("textures/entity/bloodwyrm_head.png"));
            Sheets.addWoodType((WoodType)RisusBlocks.BONDKNOT_TYPE);
        });
    }

    private static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)RisusParticles.ALTERATION.get(), AlterationParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RisusParticles.ALTERATION_FINISHED.get(), AlterationFinishedParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RisusParticles.DRIPPING_JOY.get(), JoyParticle.JoyHangProvider::new);
        event.registerSpriteSet((ParticleType)RisusParticles.FALLING_JOY.get(), JoyParticle.JoyFallProvider::new);
        event.registerSpriteSet((ParticleType)RisusParticles.JOYFLAME.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RisusParticles.LANDING_JOY.get(), JoyParticle.JoyLandProvider::new);
        event.registerSpriteSet((ParticleType)RisusParticles.TOOTHICAL.get(), ToothicalParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RisusParticles.RISUS_SOUL_PARTICLE.get(), RisusSoulParticle.EmissiveProvider::new);
        event.registerSpriteSet((ParticleType)RisusParticles.RISUS_SOUL_PARTICLE.get(), RisusSoulParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RisusParticles.BLOODSLASH_TRAIL.get(), RisusSoulParticle.EmissiveProvider::new);
        event.registerSpriteSet((ParticleType)RisusParticles.BLOODSLASH_TRAIL.get(), RisusSoulParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RisusParticles.FIERY_ORGANIC_PARTICLE.get(), FieryOrganicParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RisusParticles.DESTINED_DEATH_PARTICLE.get(), ToothicalParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RisusParticles.BLOCK_ORGANIC_PARTICLE.get(), BlockOrganicParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RisusParticles.BLOOD.get(), BloodParticle.Factory::new);
        event.registerSpriteSet((ParticleType)RisusParticles.BLOOD_BIT.get(), BloodBitParticle.Factory::new);
    }

    private static void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)RisusMenuType.MAW_GUTS.get(), MawGutsScreen::new);
    }

    private static void registerRenderTypes(RegisterNamedRenderTypesEvent event) {
    }

    private static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, getter, pos, i) -> getter != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)getter, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)RisusBlocks.MIRAGE_GRASS_BLOCK.get()});
    }

    private static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, i) -> GrassColor.get((double)0.5, (double)1.0), new ItemLike[]{(ItemLike)RisusBlocks.MIRAGE_GRASS_BLOCK.get()});
    }

    private static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        for (RisusBoat.Type boatType : RisusBoat.Type.values()) {
            event.registerLayerDefinition(RisusBoatRenderer.createBoatModelName(boatType), BoatModel::createBodyModel);
            event.registerLayerDefinition(RisusBoatRenderer.createGutsBoatModelName(boatType), GutsBoatModel::createBodyModel);
        }
        event.registerLayerDefinition(RisusModelLayers.ANGEL, AngelModel::create);
        event.registerLayerDefinition(RisusModelLayers.LICKER, LickerModel::create);
        event.registerLayerDefinition(RisusModelLayers.BABY_SPIDER, BabySpiderModel::create);
        event.registerLayerDefinition(RisusModelLayers.HOLDER, HolderModel::create);
        event.registerLayerDefinition(RisusModelLayers.MAW, MawModel::create);
        event.registerLayerDefinition(RisusModelLayers.THROWN_AXE, ThrownAxeModel::create);
        event.registerLayerDefinition(RisusModelLayers.BLOODSLASH, BloodSlashModel::create);
        event.registerLayerDefinition(RisusModelLayers.WEAVER, WeaverModel::create);
        event.registerLayerDefinition(RisusModelLayers.WEAVER_CORE, WeaverModel::create);
        event.registerLayerDefinition(RisusModelLayers.LOVER, LoverModel::create);
        event.registerLayerDefinition(RisusModelLayers.SINGER, SingerModel::create);
        event.registerLayerDefinition(RisusModelLayers.STALKER, StalkerModel::create);
        event.registerLayerDefinition(RisusModelLayers.BLOODWYRM_HEAD, BloodWyrmHeadModel::create);
        event.registerLayerDefinition(RisusModelLayers.QUESTION_MARK, QuestionMarkModel::create);
        event.registerLayerDefinition(RisusModelLayers.MEMORY1, Memory1Model::create);
        event.registerLayerDefinition(RisusModelLayers.DEPTH_VASE, DepthVaseRenderer::createBaseLayer);
    }

    private static void attachRenderLayers(EntityRenderersEvent.AddLayers event) {
        for (EntityType type : event.getEntityTypes()) {
            EntityRenderer renderer2 = event.getRenderer(type);
            if (!(renderer2 instanceof LivingEntityRenderer)) continue;
            LivingEntityRenderer living = (LivingEntityRenderer)renderer2;
            RisusClientEvents.attachRenderLayers(living);
        }
        event.getSkins().forEach(renderer -> {
            LivingEntityRenderer skin = (LivingEntityRenderer)event.getSkin(renderer);
            RisusClientEvents.attachRenderLayers(Objects.requireNonNull(skin));
        });
    }

    private static <T extends LivingEntity, M extends EntityModel<T>> void attachRenderLayers(LivingEntityRenderer<T, M> renderer) {
        EntityModelSet models = Minecraft.getInstance().getEntityModels();
        renderer.addLayer(new AngelWingsLayer<T, M>(renderer, models));
    }

    private static void registerSkullModel(EntityRenderersEvent.CreateSkullModels event) {
        event.registerSkullModel((SkullBlock.Type)RisusSkullType.BLOODWYRM, (SkullModelBase)new BloodWyrmHeadModel(event.getEntityModelSet().bakeLayer(RisusModelLayers.BLOODWYRM_HEAD)));
    }

    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)RisusEntities.ANGEL.get(), AngelRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.HOLDER.get(), HolderRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.MAW.get(), MawRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.THROWN_AXE.get(), ThrownAxeRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.BLOODSLASH.get(), BloodSlashRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.BLOODWYRM_BREATH.get(), BloodwyrmBreathEntityRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.WEAVER.get(), WeaverRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.LOVER.get(), LoverRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.SINGER.get(), SingerRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.LICKER.get(), LickerRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.BABY_SPIDER.get(), BabySpiderRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.STALKER.get(), StalkerRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.QUESTION_MARK.get(), QuestionMarkRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.TRANSIENT_QUESTION_MARK.get(), QuestionMarkRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.MEMORY1.get(), Memory1Renderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.EGG_SAC.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)RisusEntities.BOAT.get(), context -> new RisusBoatRenderer(context, false));
        event.registerEntityRenderer((EntityType)RisusEntities.GUTS_BOAT.get(), context -> new RisusBoatRenderer(context, true));
        event.registerBlockEntityRenderer((BlockEntityType)RisusBlockEntities.RISUS_SKULL.get(), SkullBlockRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RisusBlockEntities.RISUS_SIGN.get(), SignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RisusBlockEntities.RISUS_HANGING_SIGN.get(), HangingSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RisusBlockEntities.RISUS_CAMPFIRE.get(), CampfireRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RisusBlockEntities.ALTERATION_CATALYST.get(), AlterationCatalystRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RisusBlockEntities.DEPTH_VASE.get(), DepthVaseRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RisusBlockEntities.DISPLAY_NOTCH.get(), DisplayNotchRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RisusBlockEntities.RISUS_SPAWNER.get(), RisusSpawnerRenderer::new);
    }

    private static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return ResourceLocation.fromNamespaceAndPath((String)"risus", (String)"block/blood_still");
            }

            public ResourceLocation getFlowingTexture() {
                return ResourceLocation.fromNamespaceAndPath((String)"risus", (String)"block/blood_flow");
            }

            public ResourceLocation getOverlayTexture() {
                return ResourceLocation.fromNamespaceAndPath((String)"risus", (String)"block/blood_flow");
            }

            @Nullable
            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return ResourceLocation.fromNamespaceAndPath((String)"risus", (String)"textures/misc/blood_fluid_block.png");
            }

            public int getTintColor() {
                return -1700345;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return new Vector3f(0.21176471f, 0.015686275f, 0.015686275f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)0.0f);
                RenderSystem.setShaderFogEnd((float)6.0f);
            }
        }, new FluidType[]{(FluidType)RisusFluids.BLOOD_FLUID_TYPE.get()});
    }

    private static void registerOverlays(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CAMERA_OVERLAYS, ResourceLocation.fromNamespaceAndPath((String)"risus", (String)"eye_overlay"), (guiGraphics, deltaTracker) -> {
            Minecraft minecraft = Minecraft.getInstance();
            ResourceLocation overlay = ResourceLocation.fromNamespaceAndPath((String)"risus", (String)"textures/eye_overlay.png");
            LocalPlayer player = minecraft.player;
            if (player != null && player.getInventory().getArmor(3).is(RisusTags.Items.EYE)) {
                minecraft.gui.renderTextureOverlay(guiGraphics, overlay, 1.0f);
            }
        });
    }

    private static void killScreenWithAmnesia(RenderGuiLayerEvent.Pre event) {
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasEffect(RisusMobEffects.AMNESIA)) {
            event.setCanceled(true);
        }
    }

    private static void killHandWithAmnesia(RenderHandEvent event) {
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasEffect(RisusMobEffects.AMNESIA)) {
            event.setCanceled(true);
        }
    }

    private static void renderExburnHearts(PlayerHeartTypeEvent event) {
        if (event.getEntity().hasEffect(RisusMobEffects.EXBURN)) {
            event.setType(Gui.HeartType.valueOf((String)"RISUS_EXBURN"));
        }
    }

    private static void renderDeathHearts(PlayerHeartTypeEvent event) {
        if (event.getEntity().hasEffect(RisusMobEffects.DESTINED_DEATH)) {
            event.setType(Gui.HeartType.valueOf((String)"RISUS_DEATH"));
        }
    }

    private static void renderBloodcloggedHearts(PlayerHeartTypeEvent event) {
        if (event.getEntity().hasEffect(RisusMobEffects.BLOODCLOGGED)) {
            event.setType(Gui.HeartType.valueOf((String)"RISUS_BLOODCLOGGED"));
        }
    }

    public static class RenderStateAccessor
    extends RenderStateShard {
        public RenderStateAccessor(String p_110161_, Runnable p_110162_, Runnable p_110163_) {
            super(p_110161_, p_110162_, p_110163_);
        }

        public static RenderStateShard.ShaderStateShard getEndPortal() {
            return RENDERTYPE_END_PORTAL_SHADER;
        }
    }
}

