/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.model.entity;

import com.bigdious.risus.entity.Angel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class AngelModel<T extends Angel>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart innerRing;
    private final ModelPart middleRing;
    private final ModelPart outerRing;
    private final ModelPart headCluster1;
    private final ModelPart headCluster2;
    private final ModelPart topRightWing;
    private final ModelPart topLeftWing;
    private final ModelPart bottomRightWing;
    private final ModelPart bottomLeftWing;

    public AngelModel(ModelPart root) {
        this.root = root;
        this.innerRing = root.getChild("innerRing");
        this.middleRing = root.getChild("middleRing");
        this.outerRing = root.getChild("outerRing");
        this.headCluster1 = root.getChild("headCluster1");
        this.headCluster2 = root.getChild("headCluster2");
        this.topRightWing = root.getChild("topRightWing");
        this.topLeftWing = root.getChild("topLeftWing");
        this.bottomRightWing = root.getChild("bottomRightWing");
        this.bottomLeftWing = root.getChild("bottomLeftWing");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("innerRing", CubeListBuilder.create().texOffs(36, 19).addBox(-4.0f, -1.0f, -5.0f, 8.0f, 2.0f, 1.0f).texOffs(39, 19).addBox(-5.0f, -1.0f, -4.0f, 1.0f, 2.0f, 8.0f).texOffs(36, 21).addBox(4.0f, -1.0f, -4.0f, 1.0f, 2.0f, 8.0f).texOffs(40, 24).addBox(-4.0f, -1.0f, 4.0f, 8.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.4712f, (float)0.0f, (float)0.5585f));
        partdefinition.addOrReplaceChild("middleRing", CubeListBuilder.create().texOffs(37, 22).addBox(-5.0f, 5.0f, -1.0f, 10.0f, 1.0f, 2.0f).texOffs(39, 24).addBox(-5.0f, -6.0f, -1.0f, 10.0f, 1.0f, 2.0f).texOffs(45, 20).addBox(-6.0f, -5.0f, -1.0f, 1.0f, 10.0f, 2.0f).texOffs(58, 20).addBox(5.0f, -5.0f, -1.0f, 1.0f, 10.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)3.0543f, (float)1.3439f));
        partdefinition.addOrReplaceChild("outerRing", CubeListBuilder.create().texOffs(36, 19).addBox(-1.0f, 6.0f, -6.0f, 2.0f, 1.0f, 12.0f).texOffs(36, 19).addBox(-1.0f, -7.0f, -6.0f, 2.0f, 1.0f, 12.0f).texOffs(58, 19).addBox(-1.0f, -6.0f, 6.0f, 2.0f, 12.0f, 1.0f).texOffs(36, 19).addBox(-1.0f, -6.0f, -7.0f, 2.0f, 12.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)-1.0821f, (float)-2.3911f, (float)0.0f));
        partdefinition.addOrReplaceChild("headCluster1", CubeListBuilder.create().texOffs(0, 22).addBox(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("headCluster2", CubeListBuilder.create().texOffs(20, 26).addBox(-4.0f, 3.5f, -3.0f, 3.0f, 3.0f, 3.0f).texOffs(37, 44).addBox(2.0f, -2.0f, 2.0f, 3.0f, 3.0f, 3.0f).texOffs(20, 26).addBox(1.0f, -4.0f, -3.0f, 3.0f, 3.0f, 3.0f).texOffs(20, 26).addBox(-4.0f, -1.0f, -1.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("topRightWing", CubeListBuilder.create().texOffs(-13, 0).mirror().addBox(5.0f, 2.0f, -11.0f, 29.0f, 0.0f, 13.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)1.4835f, (float)-0.2182f, (float)-0.5236f));
        partdefinition.addOrReplaceChild("topLeftWing", CubeListBuilder.create().texOffs(-13, 0).addBox(-34.0f, 2.0f, -11.0f, 29.0f, 0.0f, 13.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)1.4835f, (float)0.2182f, (float)0.5236f));
        partdefinition.addOrReplaceChild("bottomRightWing", CubeListBuilder.create().texOffs(-8, 13).mirror().addBox(6.0f, 2.0f, -5.0f, 18.0f, 0.0f, 8.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)1.7017f, (float)-0.1873f, (float)0.3927f));
        partdefinition.addOrReplaceChild("bottomLeftWing", CubeListBuilder.create().texOffs(-8, 13).addBox(-24.0f, 2.0f, -5.0f, 18.0f, 0.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)1.7017f, (float)0.1873f, (float)-0.3927f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headCluster1.xRot = headPitch * ((float)Math.PI / 180);
        this.headCluster1.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.headCluster2.xRot = headPitch * ((float)Math.PI / 270);
        this.headCluster2.yRot = netHeadYaw * ((float)Math.PI / 270);
        this.headCluster2.zRot = ageInTicks * 0.01f;
        float circle = ageInTicks * 0.05f;
        float flapping = Mth.sin((float)(ageInTicks * 0.1f)) * 0.1f;
        this.innerRing.xRot = circle * 0.5f;
        this.middleRing.yRot = circle;
        this.outerRing.zRot = circle * 1.5f;
        this.topRightWing.yRot = flapping - 0.21816616f;
        this.topLeftWing.yRot = -flapping + 0.21816616f;
        this.bottomRightWing.yRot = flapping - 0.21816616f;
        this.bottomLeftWing.yRot = -flapping + 0.21816616f;
    }

    public ModelPart root() {
        return this.root;
    }
}

