/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.render;

import com.bigdious.risus.Risus;
import com.bigdious.risus.client.RisusModelLayers;
import com.bigdious.risus.client.model.entity.BloodSlashModel;
import com.bigdious.risus.entity.projectile.BloodSlash;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class BloodSlashRenderer
extends EntityRenderer<BloodSlash> {
    protected static final ResourceLocation SLASH_LOCATION = Risus.prefix("textures/entity/bloodslash.png");
    private final BloodSlashModel model;

    public BloodSlashRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new BloodSlashModel(context.bakeLayer(RisusModelLayers.BLOODSLASH));
    }

    public void render(BloodSlash slash, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        stack.pushPose();
        stack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)slash.yRotO, (float)slash.getYRot())));
        stack.translate(-1.5, 0.0, 0.0);
        stack.mulPose(Axis.XP.rotationDegrees(-slash.xRotO));
        stack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        stack.translate(0.0, 0.0, 0.0);
        stack.scale(1.0f, -1.0f, -1.0f);
        stack.translate(0.0, 0.0, 0.0);
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.model.renderType(this.getTextureLocation(slash)), (boolean)false, (boolean)false);
        this.model.renderToBuffer(stack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        stack.popPose();
        super.render((Entity)slash, yaw, partialTicks, stack, buffer, light);
    }

    public ResourceLocation getTextureLocation(BloodSlash slash) {
        return SLASH_LOCATION;
    }
}

