/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.render;

import com.bigdious.risus.Risus;
import com.bigdious.risus.blocks.entity.DepthVaseBlockEntity;
import com.bigdious.risus.client.RisusModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;

public class DepthVaseRenderer
implements BlockEntityRenderer<DepthVaseBlockEntity> {
    protected static final ResourceLocation TEXTURE = Risus.prefix("textures/entity/depth_vase.png");
    private final ModelPart vaseBody;
    private final ModelPart decoration;
    protected static final float WOBBLE_AMPLITUDE = 0.125f;

    public DepthVaseRenderer(BlockEntityRendererProvider.Context p_272872_) {
        ModelPart modelpart = p_272872_.bakeLayer(RisusModelLayers.DEPTH_VASE);
        this.vaseBody = modelpart.getChild("vaseBody");
        this.decoration = modelpart.getChild("decoration");
    }

    public static LayerDefinition createBaseLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("vaseBody", CubeListBuilder.create().texOffs(0, 27).addBox(-12.0f, -1.0f, 4.0f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(16, 42).addBox(-14.0f, -12.0f, 2.0f, 12.0f, 10.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(36, 1).addBox(-11.5f, -16.0f, 4.5f, 7.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(44, 9).mirror().addBox(-10.5f, -15.0f, 5.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(24, 16).mirror().addBox(-13.0f, -13.0f, 3.0f, 10.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(24, 27).mirror().addBox(-13.0f, -2.0f, 3.0f, 10.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)8.0f, (float)24.0f, (float)-8.0f));
        partdefinition.addOrReplaceChild("decoration", CubeListBuilder.create().texOffs(26, 31).addBox(3.5f, 3.0f, -6.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 29).addBox(2.5f, 1.0f, -6.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 30).addBox(3.5f, -1.0f, -6.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 30).addBox(5.5f, 2.0f, -5.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(25, 28).addBox(5.5f, 0.0f, -4.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(DepthVaseBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        float f;
        poseStack.pushPose();
        Direction direction = blockEntity.getDirection();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.translate(0.0, -1.5, 0.0);
        DepthVaseBlockEntity.DepthWobbleStyle wobbleStyle = blockEntity.lastWobbleStyle;
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f + direction.toYRot()));
        if (wobbleStyle != null && blockEntity.getLevel() != null && (f = ((float)(blockEntity.getLevel().getGameTime() - blockEntity.wobbleStartedAtTick) + partialTick) / (float)wobbleStyle.duration) >= 0.0f && f <= 1.0f) {
            if (wobbleStyle == DepthVaseBlockEntity.DepthWobbleStyle.POSITIVE) {
                float f1 = 0.015625f;
                float f2 = f * ((float)Math.PI * 2);
                float f3 = -1.5f * (Mth.cos((float)f2) + 0.5f) * Mth.sin((float)(f2 / 2.0f));
                poseStack.rotateAround(Axis.XP.rotation(f3 * f1), 0.5f, 0.0f, 0.5f);
                float f4 = Mth.sin((float)f2);
                poseStack.rotateAround(Axis.ZP.rotation(f4 * f1), 0.5f, 0.0f, 0.5f);
            } else {
                float f5 = Mth.sin((float)(-f * 3.0f * (float)Math.PI)) * 0.125f;
                float f6 = 1.0f - f;
                poseStack.rotateAround(Axis.YP.rotation(f5 * f6), 0.0f, 0.0f, 0.0f);
            }
        }
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE));
        this.vaseBody.render(poseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        this.decoration.render(poseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(DepthVaseBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + 1.3, (double)pos.getZ() + 1.0);
    }
}

