/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.render;

import com.bigdious.risus.blocks.entity.RisusSpawnerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class RisusSpawnerRenderer
implements BlockEntityRenderer<RisusSpawnerEntity> {
    private final EntityRenderDispatcher entityRenderer;

    public RisusSpawnerRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.getEntityRenderer();
    }

    public void render(RisusSpawnerEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BaseSpawner basespawner;
        Entity entity;
        Level level = blockEntity.getLevel();
        if (level != null && (entity = (basespawner = blockEntity.getSpawner()).getOrCreateDisplayEntity(level, blockEntity.getBlockPos())) != null) {
            RisusSpawnerRenderer.renderEntityInSpawner(partialTick, poseStack, bufferSource, packedLight, entity, this.entityRenderer, basespawner.getoSpin(), basespawner.getSpin());
        }
    }

    public static void renderEntityInSpawner(float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, Entity entity, EntityRenderDispatcher entityRenderer, double oSpin, double spin) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        float f = 0.53125f;
        float f1 = Math.max(entity.getBbWidth(), entity.getBbHeight());
        if ((double)f1 > 1.0) {
            f /= f1;
        }
        poseStack.translate(0.0f, 0.4f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees((float)Mth.lerp((double)partialTick, (double)oSpin, (double)spin) * 10.0f));
        poseStack.translate(0.0f, -0.2f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-30.0f));
        poseStack.scale(f, f, f);
        entityRenderer.render(entity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, buffer, packedLight);
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(RisusSpawnerEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 1.0, (double)pos.getY() - 1.0, (double)pos.getZ() - 1.0, (double)pos.getX() + 2.0, (double)pos.getY() + 2.0, (double)pos.getZ() + 2.0);
    }
}

