/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.data.custom;

import com.bigdious.risus.inventory.recipe.AlterationRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class AlterationRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private AlterationRecipeBuilder(ItemLike result, Ingredient input) {
        this.result = result.asItem();
        this.ingredient = input;
    }

    public static AlterationRecipeBuilder alteration(Ingredient input, ItemLike result) {
        return new AlterationRecipeBuilder(result, input);
    }

    public AlterationRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public AlterationRecipeBuilder group(@Nullable String id) {
        return this;
    }

    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput output) {
        this.save(output, BuiltInRegistries.ITEM.getKey((Object)this.getResult()).getNamespace() + ":alteration/" + BuiltInRegistries.ITEM.getKey((Object)this.getResult()).getPath());
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        this.ensureValid(id);
        Advancement.Builder builder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        AlterationRecipe recipe = new AlterationRecipe(this.ingredient, new ItemStack((ItemLike)this.result));
        output.accept(id, (Recipe)recipe, builder.build(id.withPrefix("recipes/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
    }
}

