/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.dispenser;

import com.bigdious.risus.blocks.ActuallyUseableDirectionalBlock;
import com.bigdious.risus.blocks.BiomeBlock;
import com.bigdious.risus.blocks.MultiDirectionalBlock;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.items.OrganicMatterItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class OrganicMatterDispenseBehaviour
extends DefaultDispenseItemBehavior {
    boolean fired = false;

    protected ItemStack execute(BlockSource source, ItemStack stack) {
        ServerLevel level = source.level();
        BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
        BlockState state = level.getBlockState(pos);
        RandomSource random = RandomSource.create();
        if (state.is(RisusBlocks.LAUGHING_STALK) && !((Boolean)state.getValue((Property)BiomeBlock.SPREADING)).booleanValue()) {
            level.setBlock(pos, (BlockState)((Block)RisusBlocks.LAUGHING_STALK.get()).withPropertiesOf(state).setValue((Property)BiomeBlock.SPREADING, (Comparable)Boolean.valueOf(true)), 3);
        }
        if (state.is(RisusBlocks.TISSUE)) {
            level.setBlock(pos, ((Block)RisusBlocks.LIVING_TISSUE.get()).withPropertiesOf(state), 3);
            ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)pos, (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)RisusBlocks.TISSUE.get())), (IntProvider)UniformInt.of((int)6, (int)12));
        }
        if (state.is(RisusBlocks.DECOMPOSING_TISSUE)) {
            level.setBlock(pos, ((WallBlock)RisusBlocks.DECOMPOSED_TISSUE.get()).withPropertiesOf(state), 3);
            ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)pos, (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)RisusBlocks.TISSUE.get())), (IntProvider)UniformInt.of((int)6, (int)12));
        }
        if (state.is(RisusBlocks.DECAYING_TISSUE)) {
            level.setBlock(pos, ((WallBlock)RisusBlocks.DECAYED_TISSUE.get()).withPropertiesOf(state), 3);
            ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)pos, (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)RisusBlocks.TISSUE.get())), (IntProvider)UniformInt.of((int)6, (int)12));
        }
        if (state.is(RisusBlocks.ROTTING_TISSUE)) {
            level.setBlock(pos, ((WallBlock)RisusBlocks.ROTTED_TISSUE.get()).withPropertiesOf(state), 3);
            ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)pos, (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)RisusBlocks.TISSUE.get())), (IntProvider)UniformInt.of((int)6, (int)12));
        }
        if (state.is(RisusBlocks.NEURON_HEAD) || state.is(RisusBlocks.NEURON_STEM) || state.is(RisusBlocks.VEINS) || state.is(RisusBlocks.VEINS_END) || state.is(RisusBlocks.SPREADING_REMAINS) || state.is(RisusBlocks.TEETH)) {
            OrganicMatterItem.applyOrganicMatter(stack, (Level)level, pos, null);
            OrganicMatterItem.addGrowthParticles((LevelAccessor)level, pos, 10);
        }
        if (state.is(RisusBlocks.SKIN)) {
            level.setBlock(pos, ((Block)RisusBlocks.HAIRY_SKIN.get()).withPropertiesOf(state), 3);
            ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)pos, (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Blocks.GRAY_CONCRETE)), (IntProvider)UniformInt.of((int)1, (int)1));
        }
        if (state.is(RisusBlocks.FLESHY_SKIN)) {
            level.setBlock(pos, ((Block)RisusBlocks.HAIRY_FLESHY_SKIN.get()).withPropertiesOf(state), 3);
            ParticleUtils.spawnParticlesOnBlockFace((Level)level, (BlockPos)pos, (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Blocks.GRAY_CONCRETE)), (IntProvider)UniformInt.of((int)1, (int)4), (Direction)((Direction)state.getValue((Property)ActuallyUseableDirectionalBlock.FACING)), () -> new Vec3(Mth.nextDouble((RandomSource)random, (double)-0.1, (double)0.1), Mth.nextDouble((RandomSource)random, (double)-0.1, (double)0.1), Mth.nextDouble((RandomSource)random, (double)-0.1, (double)0.1)), (double)0.6);
        }
        if (state.is(RisusBlocks.CURVED_FLESHY_SKIN)) {
            Direction directionneeded;
            level.setBlock(pos, ((Block)RisusBlocks.HAIRY_CURVED_FLESHY_SKIN.get()).withPropertiesOf(state), 3);
            Direction directionneeded2 = switch ((FrontAndTop)state.getValue(MultiDirectionalBlock.ORIENTATION)) {
                case FrontAndTop.UP_EAST -> {
                    directionneeded = Direction.UP;
                    yield Direction.SOUTH;
                }
                case FrontAndTop.UP_NORTH -> {
                    directionneeded = Direction.UP;
                    yield Direction.EAST;
                }
                case FrontAndTop.UP_SOUTH -> {
                    directionneeded = Direction.UP;
                    yield Direction.WEST;
                }
                case FrontAndTop.UP_WEST -> {
                    directionneeded = Direction.UP;
                    yield Direction.NORTH;
                }
                case FrontAndTop.EAST_UP -> {
                    directionneeded = Direction.EAST;
                    yield Direction.SOUTH;
                }
                case FrontAndTop.NORTH_UP -> {
                    directionneeded = Direction.NORTH;
                    yield Direction.EAST;
                }
                case FrontAndTop.SOUTH_UP -> {
                    directionneeded = Direction.SOUTH;
                    yield Direction.WEST;
                }
                case FrontAndTop.WEST_UP -> {
                    directionneeded = Direction.WEST;
                    yield Direction.NORTH;
                }
                case FrontAndTop.DOWN_EAST -> {
                    directionneeded = Direction.DOWN;
                    yield Direction.SOUTH;
                }
                case FrontAndTop.DOWN_NORTH -> {
                    directionneeded = Direction.DOWN;
                    yield Direction.EAST;
                }
                case FrontAndTop.DOWN_WEST -> {
                    directionneeded = Direction.DOWN;
                    yield Direction.WEST;
                }
                default -> {
                    directionneeded = Direction.DOWN;
                    yield Direction.NORTH;
                }
            };
            ParticleUtils.spawnParticlesOnBlockFace((Level)level, (BlockPos)pos, (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Blocks.GRAY_CONCRETE)), (IntProvider)UniformInt.of((int)1, (int)4), (Direction)directionneeded, () -> new Vec3(Mth.nextDouble((RandomSource)random, (double)-0.1, (double)0.1), Mth.nextDouble((RandomSource)random, (double)-0.1, (double)0.1), Mth.nextDouble((RandomSource)random, (double)-0.1, (double)0.1)), (double)0.6);
            ParticleUtils.spawnParticlesOnBlockFace((Level)level, (BlockPos)pos, (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Blocks.GRAY_CONCRETE)), (IntProvider)UniformInt.of((int)1, (int)4), (Direction)directionneeded2, () -> new Vec3(Mth.nextDouble((RandomSource)random, (double)-0.1, (double)0.1), Mth.nextDouble((RandomSource)random, (double)-0.1, (double)0.1), Mth.nextDouble((RandomSource)random, (double)-0.1, (double)0.1)), (double)0.6);
        }
        this.fired = true;
        return stack;
    }

    protected void playSound(BlockSource source) {
        if (this.fired) {
            super.playSound(source);
            this.fired = false;
        } else {
            source.level().levelEvent(1001, source.pos(), 0);
        }
    }
}

