/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity;

import com.bigdious.risus.blocks.entity.MawGutsBlockEntity;
import com.bigdious.risus.entity.RisusBoat;
import com.bigdious.risus.init.RisusEntities;
import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.inventory.MawGutsMenu;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;

public class GutsBoat
extends RisusBoat
implements HasCustomInventoryScreen,
ContainerEntity,
Hopper {
    private NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)54, (Object)ItemStack.EMPTY);
    @Nullable
    private ResourceKey<LootTable> lootTable;
    private long lootTableSeed;

    public GutsBoat(EntityType<? extends RisusBoat> type, Level level) {
        super(type, level);
    }

    public GutsBoat(Level level, double x, double y, double z) {
        this((EntityType<? extends RisusBoat>)((EntityType)RisusEntities.GUTS_BOAT.get()), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected float getSinglePassengerXOffset() {
        return 0.18f;
    }

    protected int getMaxPassengers() {
        return 1;
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.addChestVehicleSaveData(tag, (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readChestVehicleSaveData(tag, (HolderLookup.Provider)this.registryAccess());
    }

    public void destroy(DamageSource source) {
        super.destroy(source);
        this.chestVehicleDestroyed(source, this.level(), (Entity)this);
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide() && reason.shouldDestroy()) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
        }
        super.remove(reason);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        return this.canAddPassenger((Entity)player) && !player.isSecondaryUseActive() ? super.interact(player, hand) : this.interactWithContainerVehicle(player);
    }

    public void openCustomInventoryScreen(Player player) {
        player.openMenu((MenuProvider)this);
        if (!player.level().isClientSide) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
    }

    @Override
    public Item getDropItem() {
        switch (this.getRisusBoatType()) {
            default: {
                throw new MatchException(null, null);
            }
            case BONDKNOT: 
        }
        return (Item)RisusItems.GUTS_BOAT.get();
    }

    public void clearContent() {
        this.clearChestVehicleContent();
    }

    public int getContainerSize() {
        return 54;
    }

    public ItemStack getItem(int slot) {
        return this.getChestVehicleItem(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.removeChestVehicleItem(slot, amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.removeChestVehicleItemNoUpdate(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.setChestVehicleItem(slot, stack);
    }

    public SlotAccess getSlot(int index) {
        return this.getChestVehicleSlot(index);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return this.isChestVehicleStillValid(player);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        if (this.lootTable != null && player.isSpectator()) {
            return null;
        }
        this.unpackLootTable(inventory.player);
        return new MawGutsMenu(id, inventory, (Container)this);
    }

    public void unpackLootTable(@Nullable Player player) {
        this.unpackChestVehicleLootTable(player);
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> lootTable) {
        this.lootTable = lootTable;
    }

    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setLootTableSeed(long seed) {
        this.lootTableSeed = seed;
    }

    public NonNullList<ItemStack> getItemStacks() {
        return this.itemStacks;
    }

    public void clearItemStacks() {
        this.itemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.isAlive() && this.suckInItems()) {
            this.setChanged();
        }
    }

    public boolean suckInItems() {
        if (HopperBlockEntity.suckInItems((Level)this.level(), (Hopper)this)) {
            return true;
        }
        for (ItemEntity itementity : this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(1.0, 0.0, 1.0), EntitySelector.ENTITY_STILL_ALIVE)) {
            if (!MawGutsBlockEntity.addItem((Container)this, itementity)) continue;
            return true;
        }
        return false;
    }

    public double getLevelX() {
        return this.getX();
    }

    public double getLevelY() {
        return this.getY() + 0.5;
    }

    public double getLevelZ() {
        return this.getZ();
    }

    public boolean isGridAligned() {
        return false;
    }
}

