/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity;

import com.bigdious.risus.entity.Licker;
import com.bigdious.risus.entity.Singer;
import com.bigdious.risus.entity.Stalker;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusEntities;
import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.init.RisusTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class Lover
extends Monster {
    public Lover(EntityType<? extends Lover> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.xpReward = 0;
    }

    public boolean canBeLeashed() {
        return true;
    }

    public static boolean canLoverSpawn(EntityType<? extends Lover> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Lover.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FLYING_SPEED, (double)0.1f).add(Attributes.MOVEMENT_SPEED, (double)0.1f).add(Attributes.ATTACK_DAMAGE, 100.0).add(Attributes.FOLLOW_RANGE, 30.0);
    }

    protected PathNavigation createNavigation(Level p_218342_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_218342_);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    protected void checkFallDamage(double p_218316_, boolean p_218317_, BlockState p_218318_, BlockPos p_218319_) {
    }

    public void travel(Vec3 p_218382_) {
        if (this.isControlledByLocalInstance()) {
            if (this.isInWater()) {
                this.moveRelative(0.02f, p_218382_);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
            } else if (this.isInLava()) {
                this.moveRelative(0.02f, p_218382_);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            } else {
                this.moveRelative(this.getSpeed(), p_218382_);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.91f));
            }
        }
        this.calculateEntityAnimation(false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(4, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.85, false));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new TemptGoal((PathfinderMob)this, 1.25, itemStack -> itemStack.is(ItemTags.BEE_FOOD), false));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, entity -> entity.getType().is(RisusTags.Entities.LOVEABLE)));
    }

    public boolean killedEntity(ServerLevel level, LivingEntity entity) {
        int i;
        boolean flag = super.killedEntity(level, entity);
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            if (EventHooks.canLivingConvert((LivingEntity)entity, (EntityType)((EntityType)RisusEntities.STALKER.get()), timer -> {})) {
                if (level.getDifficulty() != Difficulty.HARD && this.random.nextBoolean()) {
                    return flag;
                }
                Stalker stalker = (Stalker)creeper.convertTo((EntityType)RisusEntities.STALKER.get(), false);
                if (stalker != null) {
                    stalker.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(stalker.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, false));
                    EventHooks.onLivingConvert((LivingEntity)entity, (LivingEntity)stalker);
                    if (!this.isSilent()) {
                        level.levelEvent(null, 1026, this.blockPosition(), 0);
                    }
                    if (entity.level().getBlockState(entity.getOnPos().above()).is(Blocks.AIR) && entity.level().getBlockState(entity.getOnPos()).isSolidRender((BlockGetter)level, entity.getOnPos()) && level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                        entity.level().setBlock(entity.getOnPos().above(), (BlockState)((MultifaceBlock)RisusBlocks.SPREADING_REMAINS.get()).defaultBlockState().setValue((Property)MultifaceBlock.getFaceProperty((Direction)Direction.DOWN), (Comparable)Boolean.valueOf(true)), 3);
                    }
                    for (i = 0; i < 10; ++i) {
                        level.sendParticles((ParticleOptions)ParticleTypes.HEART, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                        level.sendParticles((ParticleOptions)((SimpleParticleType)RisusParticles.RISUS_SOUL_PARTICLE.get()), entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    flag = false;
                }
            }
        }
        if (entity instanceof Spider) {
            Spider spider = (Spider)entity;
            if (EventHooks.canLivingConvert((LivingEntity)entity, (EntityType)((EntityType)RisusEntities.LICKER.get()), timer -> {})) {
                if (level.getDifficulty() != Difficulty.HARD && this.random.nextBoolean()) {
                    return flag;
                }
                Licker licker = (Licker)spider.convertTo((EntityType)RisusEntities.LICKER.get(), false);
                if (licker != null) {
                    licker.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(licker.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, false));
                    EventHooks.onLivingConvert((LivingEntity)entity, (LivingEntity)licker);
                    if (!this.isSilent()) {
                        level.levelEvent(null, 1026, this.blockPosition(), 0);
                    }
                    if (entity.level().getBlockState(entity.getOnPos().above()).is(Blocks.AIR) && entity.level().getBlockState(entity.getOnPos()).isSolidRender((BlockGetter)level, entity.getOnPos()) && level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                        entity.level().setBlock(entity.getOnPos().above(), (BlockState)((MultifaceBlock)RisusBlocks.SPREADING_REMAINS.get()).defaultBlockState().setValue((Property)MultifaceBlock.getFaceProperty((Direction)Direction.DOWN), (Comparable)Boolean.valueOf(true)), 3);
                    }
                    for (i = 0; i < 10; ++i) {
                        level.sendParticles((ParticleOptions)ParticleTypes.HEART, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                        level.sendParticles((ParticleOptions)((SimpleParticleType)RisusParticles.RISUS_SOUL_PARTICLE.get()), entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    flag = false;
                }
            }
        }
        if (entity instanceof EnderMan) {
            EnderMan enderMan = (EnderMan)entity;
            if (EventHooks.canLivingConvert((LivingEntity)entity, (EntityType)((EntityType)RisusEntities.SINGER.get()), timer -> {})) {
                if (level.getDifficulty() != Difficulty.HARD && this.random.nextBoolean()) {
                    return flag;
                }
                Singer singer = (Singer)enderMan.convertTo((EntityType)RisusEntities.SINGER.get(), false);
                if (singer != null) {
                    singer.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(singer.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, false));
                    EventHooks.onLivingConvert((LivingEntity)entity, (LivingEntity)singer);
                    if (!this.isSilent()) {
                        level.levelEvent(null, 1026, this.blockPosition(), 0);
                    }
                    if (entity.level().getBlockState(entity.getOnPos().above()).is(Blocks.AIR) && entity.level().getBlockState(entity.getOnPos()).isSolidRender((BlockGetter)level, entity.getOnPos()) && level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                        entity.level().setBlock(entity.getOnPos().above(), (BlockState)((MultifaceBlock)RisusBlocks.SPREADING_REMAINS.get()).defaultBlockState().setValue((Property)MultifaceBlock.getFaceProperty((Direction)Direction.DOWN), (Comparable)Boolean.valueOf(true)), 3);
                    }
                    for (i = 0; i < 10; ++i) {
                        level.sendParticles((ParticleOptions)ParticleTypes.HEART, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                        level.sendParticles((ParticleOptions)((SimpleParticleType)RisusParticles.RISUS_SOUL_PARTICLE.get()), entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    flag = false;
                }
            }
        }
        return flag;
    }
}

