/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity;

import com.bigdious.risus.init.RisusDamageTypes;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class QuestionMark
extends Monster {
    public QuestionMark(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 1024.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.ATTACK_DAMAGE, 10.0);
    }

    public void aiStep() {
        super.aiStep();
        this.setYRot(0.0f);
        this.yRotO = 0.0f;
        this.setYHeadRot(0.0f);
        this.yHeadRotO = 0.0f;
        this.setYBodyRot(0.0f);
        this.yBodyRotO = 0.0f;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundEvents.AMBIENT_CAVE.value();
    }

    public int getAmbientSoundInterval() {
        return 200;
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean canBeSeenAsEnemy() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public void knockback(double x, double y, double z) {
    }

    public boolean removeWhenFarAway(double dist) {
        return false;
    }

    public boolean attackable() {
        return false;
    }

    public void playerTouch(Player player) {
        if (this.isAlive() && this.hasLineOfSight((Entity)player) && player.hurt(new DamageSource((Holder)player.level().registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(RisusDamageTypes.INEXISTENCE)), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue())) {
            this.doAutoAttackOnTouch((LivingEntity)player);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        return source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && super.hurt(source, amount);
    }
}

