/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public class Singer
extends Monster {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.defineId(Singer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int targetChangeTime;

    public Singer(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.xpReward = 5;
    }

    public boolean isSensitiveToWater() {
        return true;
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.JUMP_STRENGTH, 0.0).add(Attributes.ATTACK_DAMAGE, 0.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SingerInducesNauseaAttack(this));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, player -> !player.getItemBySlot(EquipmentSlot.HEAD).is(Items.CARVED_PUMPKIN)));
    }

    public void setCharging(boolean charging) {
        this.entityData.set(DATA_IS_CHARGING, (Object)charging);
    }

    public boolean isCharging() {
        return (Boolean)this.entityData.get(DATA_IS_CHARGING);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_CHARGING, (Object)false);
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getRandomX(-0.5), this.getY() + 1.0, this.getRandomZ(-0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
        if (this.isAggressive() && this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && !this.level().isClientSide) {
            int k;
            int j;
            int i;
            BlockPos blockpos;
            RandomSource randomsource = this.getRandom();
            Level level = this.level();
            BlockState blockstate = level.getBlockState(blockpos = new BlockPos(i = Mth.floor((double)(this.getX() - 4.0 + randomsource.nextDouble() * 8.0)), j = Mth.floor((double)(this.getY() + randomsource.nextDouble() * 6.0)), k = Mth.floor((double)(this.getZ() - 4.0 + randomsource.nextDouble() * 8.0))));
            if (blockstate.is(Blocks.GLASS) || blockstate.is(Blocks.GLASS_PANE)) {
                level.destroyBlock(blockpos, true);
            }
        }
        super.aiStep();
    }

    protected void customServerAiStep() {
        float f;
        if (this.level().isDay() && this.tickCount >= this.targetChangeTime + 600 && (f = this.getLightLevelDependentMagicValue()) > 0.5f && this.level().canSeeSky(this.blockPosition()) && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.setTarget(null);
            this.teleport();
        }
        super.customServerAiStep();
    }

    protected boolean teleport() {
        if (!this.level().isClientSide() && this.isAlive()) {
            double d0 = this.getX() + (this.random.nextDouble() - 0.5) * 64.0;
            double d1 = this.getY() + (double)(this.random.nextInt(64) - 32);
            double d2 = this.getZ() + (this.random.nextDouble() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleport(double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.getY() > this.level().getMinBuildHeight() && !this.level().getBlockState((BlockPos)blockpos$mutableblockpos).blocksMotion()) {
            blockpos$mutableblockpos.move(Direction.DOWN);
        }
        BlockState blockstate = this.level().getBlockState((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.blocksMotion();
        boolean flag1 = blockstate.getFluidState().is(FluidTags.WATER);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = EventHooks.onEnderTeleport((LivingEntity)this, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.position();
            boolean flag2 = this.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.level().gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)this));
                if (!this.isSilent()) {
                    this.level().playSound(null, this.xo, this.yo, this.zo, SoundEvents.ENDERMAN_TELEPORT, this.getSoundSource(), 1.0f, 1.0f);
                    this.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENDERMAN_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource p_32527_) {
        return SoundEvents.ENDERMAN_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ENDERMAN_DEATH;
    }

    public boolean hurt(DamageSource p_32494_, float p_32495_) {
        if (this.isInvulnerableTo(p_32494_)) {
            return false;
        }
        boolean flag = p_32494_.getDirectEntity() instanceof ThrownPotion;
        if (!p_32494_.is(DamageTypeTags.IS_PROJECTILE) && !flag) {
            boolean flag1 = super.hurt(p_32494_, p_32495_);
            if (!this.level().isClientSide() && !(p_32494_.getEntity() instanceof LivingEntity) && this.random.nextInt(10) != 0) {
                this.teleport();
            }
            return flag1;
        }
        boolean flag1 = flag && this.hurtWithCleanWater(p_32494_, (ThrownPotion)p_32494_.getDirectEntity(), p_32495_);
        for (int i = 0; i < 64; ++i) {
            if (!this.teleport()) continue;
            return true;
        }
        return flag1;
    }

    private boolean hurtWithCleanWater(DamageSource p_186273_, ThrownPotion p_186274_, float p_186275_) {
        ItemStack itemstack = p_186274_.getItem();
        PotionContents potioncontents = (PotionContents)itemstack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        return potioncontents.is(Potions.WATER) && super.hurt(p_186273_, p_186275_);
    }

    static class SingerInducesNauseaAttack
    extends Goal {
        private final Singer singer;
        public int chargeTime;

        public SingerInducesNauseaAttack(Singer singer) {
            this.singer = singer;
        }

        public boolean canUse() {
            return this.singer.getTarget() != null;
        }

        public void start() {
            this.chargeTime = 0;
            this.singer.setAggressive(true);
        }

        public void stop() {
            this.singer.setCharging(false);
            this.singer.setAggressive(false);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.singer.getTarget();
            if (livingentity != null) {
                this.singer.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
                if (this.singer.hasLineOfSight((Entity)livingentity)) {
                    ++this.chargeTime;
                    if (this.chargeTime == 4) {
                        this.singer.playSound(SoundEvents.ENDERMAN_SCREAM, 4.0f, 1.1f);
                        livingentity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100, 0, false, false, true));
                        this.chargeTime = -8;
                    }
                }
            } else if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            this.singer.setCharging(this.chargeTime > 2);
        }
    }
}

