/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity.projectile;

import com.bigdious.risus.init.RisusDamageTypes;
import com.bigdious.risus.init.RisusEntities;
import com.bigdious.risus.init.RisusParticles;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class BloodSlash
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_POWER = SynchedEntityData.defineId(BloodSlash.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> ID_PIERCING = SynchedEntityData.defineId(BloodSlash.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<Entity> piercedAndKilledEntities;
    private double baseDamage;
    private int life;

    public BloodSlash(EntityType<BloodSlash> type, Level level) {
        super(type, level);
    }

    public BloodSlash(Level level, LivingEntity owner, ItemStack pPickupItemStack) {
        super((EntityType)RisusEntities.BLOODSLASH.get(), owner, level, pPickupItemStack, null);
        this.entityData.set(ID_POWER, (Object)((byte)pPickupItemStack.getEnchantmentLevel(level.registryAccess().holderOrThrow(Enchantments.POWER))));
        this.entityData.set(ID_PIERCING, (Object)((byte)pPickupItemStack.getEnchantmentLevel(level.registryAccess().holderOrThrow(Enchantments.PIERCING))));
        this.baseDamage = 15.0;
    }

    public boolean isNoGravity() {
        return true;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ID_POWER, (Object)0);
        pBuilder.define(ID_PIERCING, (Object)0);
    }

    public byte getPierceLevel() {
        return (Byte)this.entityData.get(ID_PIERCING);
    }

    public void tick() {
        super.tick();
        ++this.life;
        if (this.life >= 50) {
            this.discard();
        }
        this.level().addParticle((ParticleOptions)RisusParticles.BLOODSLASH_TRAIL.get(), true, this.getX(), this.getRandomY() - 1.5 + Math.random() * 2.8, this.getZ(), 0.0, 0.0, 0.0);
        this.playSound(SoundEvents.BREEZE_WHIRL);
    }

    protected float getWaterInertia() {
        return 1.0f;
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        float f = ((Byte)this.entityData.get(ID_POWER)).byteValue();
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().source(RisusDamageTypes.BLOODSLASH, (Entity)(entity1 == null ? this : entity1));
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f += EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getPickupItemStackOrigin(), (Entity)entity, (DamageSource)damagesource, (float)f);
        }
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
                this.discard();
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.getId());
        }
        if (entity.hurt(damagesource, (float)this.baseDamage + (float)((Byte)this.entityData.get(ID_POWER)).byteValue())) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                this.doKnockback(livingentity, damagesource);
                Level var13 = this.level();
                if (var13 instanceof ServerLevel) {
                    ServerLevel serverlevel1 = (ServerLevel)var13;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)livingentity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
                }
                this.doPostHurtEffects(livingentity);
                if (!entity.isAlive() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add((Entity)livingentity);
                }
            }
            if (this.getPierceLevel() <= 0) {
                this.discard();
            }
        }
    }

    protected boolean tryPickup(Player player) {
        return false;
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.BREEZE_LAND;
    }

    public void playerTouch(Player player) {
        if (this.ownedBy((Entity)player) || this.getOwner() == null) {
            super.playerTouch(player);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(ID_POWER, (Object)((byte)this.getPickupItemStackOrigin().getEnchantmentLevel(this.level().registryAccess().holderOrThrow(Enchantments.POWER))));
        this.entityData.set(ID_PIERCING, (Object)((byte)this.getPickupItemStackOrigin().getEnchantmentLevel(this.level().registryAccess().holderOrThrow(Enchantments.PIERCING))));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putShort("life", (short)this.life);
        compound.putDouble("damage", this.baseDamage);
        compound.putByte("PierceLevel", this.getPierceLevel());
    }

    protected boolean canHitEntity(Entity target) {
        return super.canHitEntity(target) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(target.getId()));
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }
}

