/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.event;

import com.bigdious.risus.Risus;
import com.bigdious.risus.blocks.MultiloggedRotateableBlock;
import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.bigdious.risus.entity.Angel;
import com.bigdious.risus.entity.BabySpider;
import com.bigdious.risus.entity.Holder;
import com.bigdious.risus.entity.Licker;
import com.bigdious.risus.entity.Lover;
import com.bigdious.risus.entity.Maw;
import com.bigdious.risus.entity.Memory1;
import com.bigdious.risus.entity.QuestionMark;
import com.bigdious.risus.entity.Singer;
import com.bigdious.risus.entity.Stalker;
import com.bigdious.risus.entity.TransientQuestionMark;
import com.bigdious.risus.entity.Weaver;
import com.bigdious.risus.entity.projectile.EggSac;
import com.bigdious.risus.event.OrganicMatterEvent;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusCauldronInteractions;
import com.bigdious.risus.init.RisusDispenserBehaviours;
import com.bigdious.risus.init.RisusEntities;
import com.bigdious.risus.init.RisusFluids;
import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.init.RisusMobEffects;
import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.init.RisusPotions;
import com.bigdious.risus.init.RisusSoundEvents;
import com.bigdious.risus.init.RisusTags;
import com.bigdious.risus.network.UnyieldingTotemPacket;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RisusEvents {
    public static void initEvents(IEventBus bus) {
        bus.addListener(RisusEvents::commonSetup);
        bus.addListener(RisusEvents::registerAttributes);
        bus.addListener(RisusEvents::registerSpawnPlacements);
        NeoForge.EVENT_BUS.addListener(RisusEvents::registerPotionRecipes);
        NeoForge.EVENT_BUS.addListener(RisusEvents::knockOutSomeTeeth);
        NeoForge.EVENT_BUS.addListener(RisusEvents::addExBurnParticles);
        NeoForge.EVENT_BUS.addListener(RisusEvents::addDeathParticles);
        NeoForge.EVENT_BUS.addListener(RisusEvents::addHearts);
        NeoForge.EVENT_BUS.addListener(RisusEvents::addEggSack);
        NeoForge.EVENT_BUS.addListener(RisusEvents::eggSacBoom);
        NeoForge.EVENT_BUS.addListener(RisusEvents::sacrificeAccepted);
        NeoForge.EVENT_BUS.addListener(RisusEvents::welcomePlayer);
        NeoForge.EVENT_BUS.addListener(RisusEvents::explodeStick);
        NeoForge.EVENT_BUS.addListener(RisusEvents::fireScythe);
        NeoForge.EVENT_BUS.addListener(RisusEvents::cindergleeScythe);
        NeoForge.EVENT_BUS.addListener(RisusEvents::soulScythe);
        NeoForge.EVENT_BUS.addListener(RisusEvents::hurtWings);
        NeoForge.EVENT_BUS.addListener(RisusEvents::getWaxedRisusStyle);
        NeoForge.EVENT_BUS.addListener(RisusEvents::getWaxedOffRisusStyle);
        NeoForge.EVENT_BUS.addListener(RisusEvents::onLivingDeath);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            RisusCauldronInteractions.register();
            RisusDispenserBehaviours.register();
            AxeItem.STRIPPABLES = Maps.newHashMap((Map)AxeItem.STRIPPABLES);
            AxeItem.STRIPPABLES.put((Block)RisusBlocks.BONDKNOT_LOG.get(), (Block)RisusBlocks.STRIPPED_BONDKNOT_LOG.get());
            AxeItem.STRIPPABLES.put((Block)RisusBlocks.BONDKNOT_WOOD.get(), (Block)RisusBlocks.STRIPPED_BONDKNOT_WOOD.get());
            FireBlock fireblock = (FireBlock)Blocks.FIRE;
            fireblock.setFlammable((Block)RisusBlocks.BONDKNOT_LOG.get(), 5, 5);
            fireblock.setFlammable((Block)RisusBlocks.BONDKNOT_WOOD.get(), 5, 5);
            fireblock.setFlammable((Block)RisusBlocks.STRIPPED_BONDKNOT_LOG.get(), 5, 5);
            fireblock.setFlammable((Block)RisusBlocks.STRIPPED_BONDKNOT_WOOD.get(), 5, 5);
            fireblock.setFlammable((Block)RisusBlocks.BONDKNOT_PLANKS.get(), 5, 20);
            fireblock.setFlammable((Block)RisusBlocks.BONDKNOT_STAIRS.get(), 5, 20);
            fireblock.setFlammable((Block)RisusBlocks.BONDKNOT_SLAB.get(), 5, 20);
            fireblock.setFlammable((Block)RisusBlocks.BONDKNOT_FENCE.get(), 5, 20);
            fireblock.setFlammable((Block)RisusBlocks.BONDKNOT_FENCE_GATE.get(), 5, 20);
            FlowerPotBlock pot = (FlowerPotBlock)Blocks.FLOWER_POT;
            pot.addPlant(RisusBlocks.HEART_TRANSPLANT.getId(), RisusBlocks.POTTED_HEART_TRANSPLANT);
            FlowerPotBlock pot2 = (FlowerPotBlock)Blocks.FLOWER_POT;
            pot2.addPlant(RisusBlocks.REGEN_ROSE.getId(), RisusBlocks.POTTED_REGEN_ROSE);
            WoodType.register((WoodType)RisusBlocks.BONDKNOT_TYPE);
            FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)RisusFluids.BLOOD_FLUID_TYPE.get(), fluidState -> {
                if (!fluidState.isSource()) {
                    return ((Block)RisusBlocks.SCAB.get()).defaultBlockState();
                }
                return ((Block)RisusBlocks.LAUGHING_OBSIDIAN.get()).defaultBlockState();
            }));
            FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.WATER_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)RisusFluids.BLOOD_FLUID_TYPE.get(), fluidState -> ((Block)RisusBlocks.COAGULATED_BLOOD_BLOCK.get()).defaultBlockState()));
        });
    }

    private static void registerPotionRecipes(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.AWKWARD, (Item)RisusItems.GUILTY_APPLE.get(), RisusPotions.MATING_FRENZY);
        builder.addMix(RisusPotions.MATING_FRENZY, Items.REDSTONE, RisusPotions.LONG_MATING_FRENZY);
    }

    private static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)RisusEntities.ANGEL.get(), Angel.attributes().build());
        event.put((EntityType)RisusEntities.HOLDER.get(), Holder.attributes().build());
        event.put((EntityType)RisusEntities.MAW.get(), Maw.attributes().build());
        event.put((EntityType)RisusEntities.WEAVER.get(), Weaver.attributes().build());
        event.put((EntityType)RisusEntities.LOVER.get(), Lover.attributes().build());
        event.put((EntityType)RisusEntities.SINGER.get(), Singer.attributes().build());
        event.put((EntityType)RisusEntities.LICKER.get(), Licker.attributes().build());
        event.put((EntityType)RisusEntities.BABY_SPIDER.get(), BabySpider.attributes().build());
        event.put((EntityType)RisusEntities.STALKER.get(), Stalker.attributes().build());
        event.put((EntityType)RisusEntities.QUESTION_MARK.get(), QuestionMark.attributes().build());
        event.put((EntityType)RisusEntities.TRANSIENT_QUESTION_MARK.get(), TransientQuestionMark.attributes().build());
        event.put((EntityType)RisusEntities.MEMORY1.get(), Memory1.attributes().build());
    }

    private static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)RisusEntities.LOVER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Lover::canLoverSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    private static void knockOutSomeTeeth(LivingIncomingDamageEvent event) {
        Level level;
        Player player;
        Entity source = event.getSource().getEntity();
        if (source instanceof Player && (player = (Player)source).hasEffect(RisusMobEffects.TOOTHLUSTER) && (level = event.getEntity().level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)RisusParticles.TOOTHICAL.get()), event.getEntity().getX(), event.getEntity().getEyeY(), event.getEntity().getZ(), 10, 0.0, 0.0, 0.0, 1.0);
        }
    }

    public static OrganicMatterEvent fireOrganicMatterEvent(@Nullable Player player, Level level, BlockPos pos, BlockState state, ItemStack stack) {
        return (OrganicMatterEvent)NeoForge.EVENT_BUS.post((Event)new OrganicMatterEvent(player, level, pos, state, stack));
    }

    private static void addExBurnParticles(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            Level level;
            LivingEntity living = (LivingEntity)entity;
            if (living.tickCount % 5 == 0 && living.hasEffect(RisusMobEffects.EXBURN) && (level = living.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 2; ++i) {
                    serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)RisusParticles.FIERY_ORGANIC_PARTICLE.get()), living.getRandomX(0.5), living.getRandomY(), living.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private static void addDeathParticles(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            Level level;
            LivingEntity living = (LivingEntity)entity;
            if (living.tickCount % 5 == 0 && living.hasEffect(RisusMobEffects.DESTINED_DEATH) && (level = living.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 2; ++i) {
                    serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)RisusParticles.DESTINED_DEATH_PARTICLE.get()), living.getRandomX(0.5), living.getRandomY(), living.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private static void addHearts(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            Level level;
            LivingEntity living = (LivingEntity)entity;
            if (living.tickCount % 5 == 0 && living.hasEffect(RisusMobEffects.MATING_FRENZY) && (level = living.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, living.getRandomX(0.5), living.getRandomY(), living.getRandomZ(0.5), 3, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void welcomePlayer(AdvancementEvent.AdvancementEarnEvent event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (event.getAdvancement().id().equals((Object)Risus.prefix("first"))) {
            for (int i = 0; i < 13; ++i) {
                QuestionMark witness = (QuestionMark)((EntityType)RisusEntities.TRANSIENT_QUESTION_MARK.get()).create(level);
                witness.moveTo(player.getRandomX(40.0), player.getRandomY() + 2.0 + 11.0 * (player.getRandomY() - player.getRandomY()), player.getRandomZ(40.0), 0.0f, 0.0f);
                level.addFreshEntity((Entity)witness);
            }
        }
    }

    private static void explodeStick(LivingIncomingDamageEvent event) {
        LivingEntity attacker;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity).getMainHandItem().is((Item)RisusItems.BOOMSTICK.get())) {
            RisusEvents.explode(attacker.level(), attacker.getOnPos(), attacker);
            attacker.getMainHandItem().hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        }
    }

    private static void explode(Level level, BlockPos pos, LivingEntity entity) {
        Vec3 vec3 = pos.getCenter().add(0.0, 1.0, 0.0);
        level.explode(null, level.damageSources().explosion((Entity)entity, null), null, vec3, 3.0f, false, Level.ExplosionInteraction.BLOCK);
    }

    private static void fireScythe(LivingDamageEvent.Post event) {
        Entity entity = event.getSource().getEntity();
        LivingEntity entity2 = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (entity2 instanceof LivingEntity) {
                LivingEntity victim = entity2;
                if (attacker.getMainHandItem().is((Item)RisusItems.FIRE_SCYTHE.get())) {
                    victim.addEffect(new MobEffectInstance(RisusMobEffects.FLAME_FRAILTY, 200, 0, false, false, true));
                    victim.igniteForSeconds(2.0f);
                }
            }
        }
    }

    private static void cindergleeScythe(LivingDamageEvent.Post event) {
        Entity entity = event.getSource().getEntity();
        LivingEntity entity2 = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (entity2 instanceof LivingEntity) {
                LivingEntity victim = entity2;
                if (attacker.getMainHandItem().is((Item)RisusItems.CINDERGLEE_SCYTHE.get())) {
                    victim.addEffect(new MobEffectInstance(RisusMobEffects.EXBURN, 600, 0, false, false, true));
                }
            }
        }
    }

    private static void soulScythe(LivingIncomingDamageEvent event) {
        Entity entity = event.getSource().getEntity();
        LivingEntity entity2 = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (entity2 instanceof LivingEntity) {
                LivingEntity victim = entity2;
                if (attacker.getMainHandItem().is((Item)RisusItems.SOUL_SCYTHE.get())) {
                    if (!victim.getType().is(EntityTypePredicate.of((TagKey)EntityTypeTags.SENSITIVE_TO_SMITE).types()) && !victim.getType().is(RisusTags.Entities.OFFSPRING)) {
                        event.setAmount(event.getAmount() + 5.0f);
                    } else {
                        event.setAmount(event.getAmount() - 3.0f);
                    }
                }
            }
        }
    }

    private static void addEggSack(LivingDeathEvent event) {
        Licker licker;
        Level level;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Licker && (level = (licker = (Licker)entity).level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.ITEM_COBWEB, licker.getRandomX(0.5), licker.getY() + 1.0, licker.getRandomZ(0.5), 7, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void eggSacBoom(ProjectileImpactEvent event) {
        EggSac eggSac;
        Level level;
        Projectile entity = event.getProjectile();
        if (entity instanceof EggSac && (level = (eggSac = (EggSac)entity).level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.ITEM_COBWEB, eggSac.getRandomX(0.5), eggSac.getY(), eggSac.getRandomZ(0.5), 7, 0.0, 0.0, 0.0, 0.0);
            serverLevel.playLocalSound((Entity)eggSac, SoundEvents.TURTLE_EGG_HATCH, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private static void sacrificeAccepted(LivingDeathEvent event) {
        Player cultist;
        LivingEntity sacrifice = event.getEntity();
        LivingEntity murderer = event.getEntity().getKillCredit();
        if ((sacrifice instanceof Player || sacrifice instanceof AbstractVillager || sacrifice instanceof AbstractIllager || sacrifice instanceof Witch) && murderer instanceof Player && (cultist = (Player)murderer).getOffhandItem().is(RisusItems.SACRIFICE_CATALYST)) {
            Level level = murderer.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 5; ++i) {
                    serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)RisusParticles.FALLING_JOY.get()), sacrifice.getRandomX(0.5), sacrifice.getRandomY(), sacrifice.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (cultist.getOffhandItem().getDamageValue() > 1) {
                cultist.getOffhandItem().setDamageValue(cultist.getOffhandItem().getDamageValue() - 1);
            } else {
                cultist.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)RisusItems.THOUSAND_BLADE.asItem()));
            }
        }
    }

    private static void hurtWings(PlayerInteractEvent.RightClickItem event) {
        if (event.getItemStack().is(RisusTags.Items.HURTS_ANGEL_WINGS) && event.getEntity().getItemBySlot(EquipmentSlot.CHEST).is(RisusItems.ANGEL_WINGS) && event.getEntity().isFallFlying()) {
            event.getEntity().getItemBySlot(EquipmentSlot.CHEST).hurtAndBreak(30, (LivingEntity)event.getEntity(), EquipmentSlot.CHEST);
        }
        if (event.getItemStack().is(RisusTags.Items.LIGHTLY_HURTS_ANGEL_WINGS) && event.getEntity().getItemBySlot(EquipmentSlot.CHEST).is(RisusItems.ANGEL_WINGS) && (event.getEntity().isFallFlying() || event.getEntity().isInWaterRainOrBubble() || event.getEntity().isInLava())) {
            event.getEntity().getItemBySlot(EquipmentSlot.CHEST).hurtAndBreak(5, (LivingEntity)event.getEntity(), EquipmentSlot.CHEST);
        }
    }

    private static void getWaxedRisusStyle(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().is(Items.HONEYCOMB) && event.getLevel().getBlockState(event.getPos()).is(RisusTags.Blocks.COPPER_AMALGAM_VARIATION)) {
            if (event.getLevel().getBlockState(event.getPos()).is(RisusBlocks.COPPER_AMALGAM)) {
                event.getLevel().setBlock(event.getPos(), (BlockState)((BlockState)((Block)RisusBlocks.WAXED_COPPER_AMALGAM.get()).defaultBlockState().setValue((Property)MultiloggedRotateableBlock.FACING, (Comparable)((Direction)event.getLevel().getBlockState(event.getPos()).getValue((Property)MultiloggedRotateableBlock.FACING)))).setValue(MultiloggedRotateableBlock.FLUIDLOGGED, (Comparable)((Object)((SimpleMultiloggedBlock.MultiloggingEnum)((Object)event.getLevel().getBlockState(event.getPos()).getValue(MultiloggedRotateableBlock.FLUIDLOGGED))))), 11);
            } else if (event.getLevel().getBlockState(event.getPos()).is(RisusBlocks.EXPOSED_COPPER_AMALGAM)) {
                event.getLevel().setBlock(event.getPos(), (BlockState)((BlockState)((Block)RisusBlocks.WAXED_EXPOSED_COPPER_AMALGAM.get()).defaultBlockState().setValue((Property)MultiloggedRotateableBlock.FACING, (Comparable)((Direction)event.getLevel().getBlockState(event.getPos()).getValue((Property)MultiloggedRotateableBlock.FACING)))).setValue(MultiloggedRotateableBlock.FLUIDLOGGED, (Comparable)((Object)((SimpleMultiloggedBlock.MultiloggingEnum)((Object)event.getLevel().getBlockState(event.getPos()).getValue(MultiloggedRotateableBlock.FLUIDLOGGED))))), 11);
            } else if (event.getLevel().getBlockState(event.getPos()).is(RisusBlocks.WEATHERED_COPPER_AMALGAM)) {
                event.getLevel().setBlock(event.getPos(), (BlockState)((BlockState)((Block)RisusBlocks.WAXED_WEATHERED_COPPER_AMALGAM.get()).defaultBlockState().setValue((Property)MultiloggedRotateableBlock.FACING, (Comparable)((Direction)event.getLevel().getBlockState(event.getPos()).getValue((Property)MultiloggedRotateableBlock.FACING)))).setValue(MultiloggedRotateableBlock.FLUIDLOGGED, (Comparable)((Object)((SimpleMultiloggedBlock.MultiloggingEnum)((Object)event.getLevel().getBlockState(event.getPos()).getValue(MultiloggedRotateableBlock.FLUIDLOGGED))))), 11);
            } else if (event.getLevel().getBlockState(event.getPos()).is(RisusBlocks.OXIDIZED_COPPER_AMALGAM)) {
                event.getLevel().setBlock(event.getPos(), (BlockState)((BlockState)((Block)RisusBlocks.WAXED_OXIDIZED_COPPER_AMALGAM.get()).defaultBlockState().setValue((Property)MultiloggedRotateableBlock.FACING, (Comparable)((Direction)event.getLevel().getBlockState(event.getPos()).getValue((Property)MultiloggedRotateableBlock.FACING)))).setValue(MultiloggedRotateableBlock.FLUIDLOGGED, (Comparable)((Object)((SimpleMultiloggedBlock.MultiloggingEnum)((Object)event.getLevel().getBlockState(event.getPos()).getValue(MultiloggedRotateableBlock.FLUIDLOGGED))))), 11);
            }
            ParticleUtils.spawnParticlesOnBlockFaces((Level)event.getLevel(), (BlockPos)event.getPos(), (ParticleOptions)ParticleTypes.WAX_ON, (IntProvider)UniformInt.of((int)6, (int)12));
            event.getLevel().playSound(null, event.getPos(), SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void getWaxedOffRisusStyle(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().is(ItemTags.AXES) && event.getLevel().getBlockState(event.getPos()).is(RisusTags.Blocks.WAXED_COPPER_AMALGAM_VARIATION)) {
            if (event.getLevel().getBlockState(event.getPos()).is(RisusBlocks.WAXED_COPPER_AMALGAM)) {
                event.getLevel().setBlock(event.getPos(), (BlockState)((BlockState)((Block)RisusBlocks.COPPER_AMALGAM.get()).defaultBlockState().setValue((Property)MultiloggedRotateableBlock.FACING, (Comparable)((Direction)event.getLevel().getBlockState(event.getPos()).getValue((Property)MultiloggedRotateableBlock.FACING)))).setValue(MultiloggedRotateableBlock.FLUIDLOGGED, (Comparable)((Object)((SimpleMultiloggedBlock.MultiloggingEnum)((Object)event.getLevel().getBlockState(event.getPos()).getValue(MultiloggedRotateableBlock.FLUIDLOGGED))))), 11);
            } else if (event.getLevel().getBlockState(event.getPos()).is(RisusBlocks.WAXED_EXPOSED_COPPER_AMALGAM)) {
                event.getLevel().setBlock(event.getPos(), (BlockState)((BlockState)((Block)RisusBlocks.EXPOSED_COPPER_AMALGAM.get()).defaultBlockState().setValue((Property)MultiloggedRotateableBlock.FACING, (Comparable)((Direction)event.getLevel().getBlockState(event.getPos()).getValue((Property)MultiloggedRotateableBlock.FACING)))).setValue(MultiloggedRotateableBlock.FLUIDLOGGED, (Comparable)((Object)((SimpleMultiloggedBlock.MultiloggingEnum)((Object)event.getLevel().getBlockState(event.getPos()).getValue(MultiloggedRotateableBlock.FLUIDLOGGED))))), 11);
            } else if (event.getLevel().getBlockState(event.getPos()).is(RisusBlocks.WAXED_WEATHERED_COPPER_AMALGAM)) {
                event.getLevel().setBlock(event.getPos(), (BlockState)((BlockState)((Block)RisusBlocks.WEATHERED_COPPER_AMALGAM.get()).defaultBlockState().setValue((Property)MultiloggedRotateableBlock.FACING, (Comparable)((Direction)event.getLevel().getBlockState(event.getPos()).getValue((Property)MultiloggedRotateableBlock.FACING)))).setValue(MultiloggedRotateableBlock.FLUIDLOGGED, (Comparable)((Object)((SimpleMultiloggedBlock.MultiloggingEnum)((Object)event.getLevel().getBlockState(event.getPos()).getValue(MultiloggedRotateableBlock.FLUIDLOGGED))))), 11);
            } else if (event.getLevel().getBlockState(event.getPos()).is(RisusBlocks.WAXED_OXIDIZED_COPPER_AMALGAM)) {
                event.getLevel().setBlock(event.getPos(), (BlockState)((BlockState)((Block)RisusBlocks.OXIDIZED_COPPER_AMALGAM.get()).defaultBlockState().setValue((Property)MultiloggedRotateableBlock.FACING, (Comparable)((Direction)event.getLevel().getBlockState(event.getPos()).getValue((Property)MultiloggedRotateableBlock.FACING)))).setValue(MultiloggedRotateableBlock.FLUIDLOGGED, (Comparable)((Object)((SimpleMultiloggedBlock.MultiloggingEnum)((Object)event.getLevel().getBlockState(event.getPos()).getValue(MultiloggedRotateableBlock.FLUIDLOGGED))))), 11);
            }
            ParticleUtils.spawnParticlesOnBlockFaces((Level)event.getLevel(), (BlockPos)event.getPos(), (ParticleOptions)ParticleTypes.WAX_OFF, (IntProvider)UniformInt.of((int)6, (int)12));
            event.getLevel().playSound(null, event.getPos(), SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static boolean onLivingDeath(@NotNull LivingDeathEvent event) {
        LivingEntity dyingEntity = event.getEntity();
        Level level = dyingEntity.getCommandSenderWorld();
        if (!level.isClientSide && (dyingEntity.getMainHandItem().is((Item)RisusItems.TOTEM_OF_UNYIELDING.get()) || dyingEntity.getOffhandItem().is((Item)RisusItems.TOTEM_OF_UNYIELDING.get()))) {
            dyingEntity.setHealth(1.0f);
            dyingEntity.removeAllEffects();
            dyingEntity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 200, 4, false, false));
            dyingEntity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 200, 2, false, false));
            dyingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200, 1, false, false));
            dyingEntity.addEffect(new MobEffectInstance(RisusMobEffects.DESTINED_DEATH, 200, 0, false, false, true));
            if (dyingEntity.getMainHandItem().is((Item)RisusItems.TOTEM_OF_UNYIELDING.get())) {
                dyingEntity.getMainHandItem().shrink(1);
            } else {
                dyingEntity.getOffhandItem().shrink(1);
            }
            level.playSound(null, dyingEntity.getOnPos(), SoundEvents.TOTEM_USE, SoundSource.NEUTRAL);
            if (dyingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)dyingEntity;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new UnyieldingTotemPacket(new ItemStack((ItemLike)RisusItems.TOTEM_OF_UNYIELDING.get()), (ResourceKey<SoundEvent>)RisusSoundEvents.SQUIRT.getKey()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            event.setCanceled(true);
        }
        return false;
    }
}

