/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.init;

import com.bigdious.risus.Risus;
import com.bigdious.risus.init.RisusBannerPatterns;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class RisusTags {

    public static class BannerPatternTagGenerator
    extends TagsProvider<BannerPattern> {
        public static final TagKey<BannerPattern> SMILE_PATTERN = BannerPatternTagGenerator.create("pattern_item/smile");
        public static final TagKey<BannerPattern> DIVINITY_PATTERN = BannerPatternTagGenerator.create("pattern_item/divinity");
        public static final TagKey<BannerPattern> TREE_PATTERN = BannerPatternTagGenerator.create("pattern_item/tree");

        public BannerPatternTagGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, Registries.BANNER_PATTERN, provider, "risus", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(SMILE_PATTERN).add(RisusBannerPatterns.SMILE);
            this.tag(DIVINITY_PATTERN).add(RisusBannerPatterns.DIVINITY);
            this.tag(TREE_PATTERN).add(RisusBannerPatterns.TREE);
        }

        private static TagKey<BannerPattern> create(String name) {
            return TagKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)Risus.prefix(name));
        }

        public String getName() {
            return "Risus Banner Pattern Tags";
        }
    }

    public static class Entities {
        public static final TagKey<EntityType<?>> OFFSPRING = Entities.tag("offspring");
        public static final TagKey<EntityType<?>> BELOVED = Entities.tag("beloved");
        public static final TagKey<EntityType<?>> LOVEABLE = Entities.tag("loveable");
        public static final TagKey<EntityType<?>> CANT_BE_STOLEN_FROM = Entities.tag("cant_be_stolen_from");
        public static final TagKey<EntityType<?>> CANT_BE_STRIPPED = Entities.tag("cant_be_stripped");

        private static TagKey<EntityType<?>> tag(String name) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"risus", (String)name));
        }
    }

    public static class Items {
        public static final TagKey<Item> BONE_BLOCK_VARIATION = Items.tag("bone_block_variation");
        public static final TagKey<Item> WILLFUL_WEAPON = Items.tag("willful_weapon");
        public static final TagKey<Item> EYE = Items.tag("eye");
        public static final TagKey<Item> BASE_TISSUE = Items.tag("base_tissue");
        public static final TagKey<Item> HURTS_ANGEL_WINGS = Items.tag("hurts_angel_wings");
        public static final TagKey<Item> LIGHTLY_HURTS_ANGEL_WINGS = Items.tag("lightly_hurts_angel_wings");
        public static final TagKey<Item> ALTERABLE_GATES = Items.tag("alterable_gates");
        public static final TagKey<Item> ALTERABLE_FENCES = Items.tag("alterable_fences");
        public static final TagKey<Item> ALTERABLE_TRAPDOORS = Items.tag("alterable_trapdoors");
        public static final TagKey<Item> ALTERABLE_HANGING_SIGNS = Items.tag("alterable_hanging_signs");
        public static final TagKey<Item> ALTERABLE_SIGNS = Items.tag("alterable_signs");
        public static final TagKey<Item> ALTERABLE_DOORS = Items.tag("alterable_doors");
        public static final TagKey<Item> ALTERABLE_BUTTONS = Items.tag("alterable_buttons");
        public static final TagKey<Item> ALTERABLE_PRESSURE_PLATES = Items.tag("alterable_pressure_plates");
        public static final TagKey<Item> ALTERABLE_SLABS = Items.tag("alterable_slabs");
        public static final TagKey<Item> ALTERABLE_STAIRS = Items.tag("alterable_stairs");
        public static final TagKey<Item> ALTERABLE_PLANKS = Items.tag("alterable_planks");
        public static final TagKey<Item> ALTERABLE_LOGS = Items.tag("alterable_logs");
        public static final TagKey<Item> ALTERABLE_STRIPPED_LOGS = Items.tag("alterable_logs");
        public static final TagKey<Item> ALTERABLE_WOODS = Items.tag("alterable_woods");
        public static final TagKey<Item> ALTERABLE_STRIPPED_WOODS = Items.tag("alterable_woods");

        private static TagKey<Item> tag(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"risus", (String)name));
        }
    }

    public static class Biomes {
        public static final TagKey<Biome> HAS_ALTERATION_SITE = Biomes.tag("has_structure/alteration_site");
        public static final TagKey<Biome> HAS_GRASSY_MAW = Biomes.tag("has_structure/grassy_maw");
        public static final TagKey<Biome> HAS_SANDY_MAW = Biomes.tag("has_structure/sandy_maw");
        public static final TagKey<Biome> HAS_ENDY_MAW = Biomes.tag("has_structure/endy_maw");
        public static final TagKey<Biome> HAS_FAMILY_TREE = Biomes.tag("has_structure/family_tree");
        public static final TagKey<Biome> HAS_ANGEL_ALTAR = Biomes.tag("has_structure/angel_altar");
        public static final TagKey<Biome> HAS_GREAT_BODY = Biomes.tag("has_structure/great_body");
        public static final TagKey<Biome> HAS_FLOWER_FIELD = Biomes.tag("has_structure/flower_field");
        public static final TagKey<Biome> HAS_DUNGEON = Biomes.tag("has_structure/dungeon");
        public static final TagKey<Biome> HAS_BLOOD_WELL = Biomes.tag("has_structure/blood_well");
        public static final TagKey<Biome> HAS_LAB = Biomes.tag("has_structure/lab");
        public static final TagKey<Biome> HAS_DRAXOLOTL_REMAINS = Biomes.tag("has_structure/draxolotl_remains");

        private static TagKey<Biome> tag(String name) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"risus", (String)name));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> COPPER_AMALGAM_VARIATION = Blocks.tag("copper_amalgam_variation");
        public static final TagKey<Block> WAXED_COPPER_AMALGAM_VARIATION = Blocks.tag("waxed_copper_amalgam_variation");

        private static TagKey<Block> tag(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"risus", (String)name));
        }
    }
}

