/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items;

import com.bigdious.risus.entity.projectile.BloodwyrmBreathEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BloodwyrmHeadItem
extends Item {
    public BloodwyrmHeadItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!player.isInWaterOrRain()) {
            if (itemstack.getDamageValue() >= 200) {
                int validSlot = 0;
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack checkStack = player.getInventory().getItem(i);
                    if (!checkStack.is(Items.DRAGON_BREATH)) continue;
                    validSlot = i;
                    break;
                }
                ItemStack ammo = player.getInventory().getItem(validSlot);
                if (validSlot != -1 && ammo.is(Items.DRAGON_BREATH)) {
                    itemstack.hurtAndBreak(-200, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    ammo.shrink(1);
                    player.spawnAtLocation((ItemLike)Items.GLASS_BOTTLE);
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_EMPTY, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
                }
            }
            if (itemstack.getDamageValue() == itemstack.getMaxDamage()) {
                return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
            }
            player.startUsingItem(hand);
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int count) {
        if (stack.getDamageValue() == stack.getMaxDamage()) {
            player.stopUsingItem();
            return;
        }
        if (count % 5 == 0 && !level.isClientSide()) {
            BloodwyrmBreathEntity breath = new BloodwyrmBreathEntity(level, player, stack);
            breath.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.0f, 15.0f);
            level.addFreshEntity((Entity)breath);
            stack.hurtAndBreak(1, player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FIRE_AMBIENT, SoundSource.PLAYERS, 0.5f, 0.75f);
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack.getItem() == newStack.getItem();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.getItem() != oldStack.getItem();
    }
}

