/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class EndlessPearlItem
extends EnderpearlItem {
    public EndlessPearlItem(Item.Properties props) {
        super(props);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        int validSlot = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack checkStack = player.getInventory().getItem(i);
            if (!checkStack.is(Items.ENDER_PEARL)) continue;
            validSlot = i;
            break;
        }
        ItemStack ammo = player.getInventory().getItem(validSlot);
        int amount = ammo.getCount();
        if (validSlot == -1 || !ammo.is(Items.ENDER_PEARL) || itemstack.getDamageValue() < amount) {
            if (itemstack.getDamageValue() == itemstack.getMaxDamage()) {
                return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            player.getCooldowns().addCooldown((Item)this, 20);
            if (!level.isClientSide) {
                ThrownEnderpearl thrownenderpearl = new ThrownEnderpearl(level, (LivingEntity)player);
                thrownenderpearl.setItem(itemstack);
                thrownenderpearl.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
                level.addFreshEntity((Entity)thrownenderpearl);
                itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            }
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        itemstack.hurtAndBreak(-amount, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
        ammo.shrink(amount);
        return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
    }

    public boolean isEnchantable(ItemStack itemstack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack itemstack, ItemStack book) {
        return false;
    }
}

