/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items;

import com.bigdious.risus.attachment.ExBurnAttachment;
import com.bigdious.risus.blocks.interfaces.OrganicMatterableBlock;
import com.bigdious.risus.event.OrganicMatterEvent;
import com.bigdious.risus.event.RisusEvents;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusDataAttachments;
import com.bigdious.risus.init.RisusParticles;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class OrganicMatterItem
extends Item {
    public static final Supplier<BiMap<Block, Block>> PRESERVABLE = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)RisusBlocks.TISSUE.get()), (Object)((Block)RisusBlocks.LIVING_TISSUE.get())).put((Object)((Block)RisusBlocks.ROTTING_TISSUE.get()), (Object)((Block)RisusBlocks.ROTTED_TISSUE.get())).put((Object)((Block)RisusBlocks.DECOMPOSING_TISSUE.get()), (Object)((Block)RisusBlocks.DECOMPOSED_TISSUE.get())).put((Object)((Block)RisusBlocks.DECAYING_TISSUE.get()), (Object)((Block)RisusBlocks.DECAYED_TISSUE.get())).build());

    public OrganicMatterItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ((ExBurnAttachment)entity.getData(RisusDataAttachments.EX_BURN)).incrementHealth(entity);
        return super.finishUsingItem(stack, level, entity);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        if (OrganicMatterItem.applyOrganicMatter(context.getItemInHand(), level, blockpos, context.getPlayer())) {
            if (!level.isClientSide) {
                context.getPlayer().gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                level.levelEvent(1505, blockpos, 15);
            }
            OrganicMatterItem.addGrowthParticles((LevelAccessor)level, blockpos, 10);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return OrganicMatterItem.getWaxed(blockstate).map(state -> {
            Player player = context.getPlayer();
            ItemStack itemstack = context.getItemInHand();
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
            }
            itemstack.shrink(1);
            level.setBlock(blockpos, state, 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)state));
            ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)blockpos, (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)RisusBlocks.TISSUE.get())), (IntProvider)UniformInt.of((int)6, (int)12));
            level.playSound(null, blockpos, SoundEvents.SCULK_VEIN_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }).orElse(InteractionResult.PASS);
    }

    public static boolean applyOrganicMatter(ItemStack p_40628_, Level p_40629_, BlockPos p_40630_, @Nullable Player player) {
        OrganicMatterableBlock organicMatterableBlock;
        BlockState blockstate = p_40629_.getBlockState(p_40630_);
        OrganicMatterEvent event = RisusEvents.fireOrganicMatterEvent(player, p_40629_, p_40630_, blockstate, p_40628_);
        if (event.isCanceled()) {
            return event.isSuccessful();
        }
        Block block = blockstate.getBlock();
        if (block instanceof OrganicMatterableBlock && (organicMatterableBlock = (OrganicMatterableBlock)block).isValidOrganicMatterTarget((LevelReader)p_40629_, p_40630_, blockstate)) {
            if (p_40629_ instanceof ServerLevel) {
                if (organicMatterableBlock.isOrganicMatterSuccess(p_40629_, p_40629_.random, p_40630_, blockstate)) {
                    organicMatterableBlock.performOrganicMatter((ServerLevel)p_40629_, p_40629_.random, p_40630_, blockstate);
                }
                p_40628_.shrink(1);
            }
            return true;
        }
        return false;
    }

    public static void addGrowthParticles(LevelAccessor pLevel, BlockPos pPos, int pData) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        Block block = blockstate.getBlock();
        if (block instanceof OrganicMatterableBlock) {
            OrganicMatterableBlock organicMatterableBlock = (OrganicMatterableBlock)block;
            BlockPos blockpos = organicMatterableBlock.getOMBParticlePos(pPos);
            switch (organicMatterableBlock.getOMBType()) {
                case NEIGHBOR_SPREADER: {
                    ParticleUtils.spawnParticles((LevelAccessor)pLevel, (BlockPos)blockpos, (int)(pData * 3), (double)3.0, (double)1.0, (boolean)false, (ParticleOptions)((ParticleOptions)RisusParticles.BLOCK_ORGANIC_PARTICLE.get()));
                    break;
                }
                case GROWER: {
                    ParticleUtils.spawnParticleInBlock((LevelAccessor)pLevel, (BlockPos)blockpos, (int)pData, (ParticleOptions)((ParticleOptions)RisusParticles.BLOCK_ORGANIC_PARTICLE.get()));
                }
            }
        } else if (blockstate.is(Blocks.WATER)) {
            ParticleUtils.spawnParticles((LevelAccessor)pLevel, (BlockPos)pPos, (int)(pData * 3), (double)3.0, (double)1.0, (boolean)false, (ParticleOptions)((ParticleOptions)RisusParticles.BLOCK_ORGANIC_PARTICLE.get()));
        }
    }

    public static Optional<BlockState> getWaxed(BlockState state) {
        return Optional.ofNullable((Block)PRESERVABLE.get().get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state));
    }
}

