/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items;

import com.bigdious.risus.Risus;
import com.bigdious.risus.blocks.RisusCampfireBlock;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.init.RisusParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ScytheItem
extends SwordItem {
    public ScytheItem(Tier material, Item.Properties properties) {
        super(material, properties);
    }

    public static ItemAttributeModifiers createScytheAttributes(Tier tier, int damage, float speed) {
        return SwordItem.createAttributes((Tier)tier, (int)damage, (float)speed).withModifierAdded(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(Risus.prefix("range_modifier"), 2.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.SWEEPING_DAMAGE_RATIO, new AttributeModifier(Risus.prefix("range_modifier"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack material) {
        return material.is(RisusItems.GLUTTONY_SCALES);
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.SHARPNESS) || enchantment.is(Enchantments.BANE_OF_ARTHROPODS) || enchantment.is(Enchantments.LOOTING) || enchantment.is(Enchantments.SMITE) || enchantment.is(Enchantments.MENDING) || enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.FIRE_ASPECT) || enchantment.is(Enchantments.KNOCKBACK) || enchantment.is(Enchantments.VANISHING_CURSE);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.SHARPNESS) || enchantment.is(Enchantments.BANE_OF_ARTHROPODS) || enchantment.is(Enchantments.LOOTING) || enchantment.is(Enchantments.SMITE) || enchantment.is(Enchantments.MENDING) || enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.FIRE_ASPECT) || enchantment.is(Enchantments.KNOCKBACK) || enchantment.is(Enchantments.VANISHING_CURSE);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        Player player = pContext.getPlayer();
        ItemStack scythe = player.getMainHandItem();
        if (level.getBlockState(blockpos.below().east()).is(RisusBlocks.LINEAR_RITUAL_BLOCK) && level.getBlockState(blockpos.below().west()).is(RisusBlocks.LINEAR_RITUAL_BLOCK) && level.getBlockState(blockpos.below().south()).is(RisusBlocks.LINEAR_RITUAL_BLOCK) && level.getBlockState(blockpos.below().north()).is(RisusBlocks.LINEAR_RITUAL_BLOCK) && level.getBlockState(blockpos.below().north().east()).is(RisusBlocks.CURVED_RITUAL_BLOCK) && level.getBlockState(blockpos.below().north().west()).is(RisusBlocks.CURVED_RITUAL_BLOCK) && level.getBlockState(blockpos.below().south().east()).is(RisusBlocks.CURVED_RITUAL_BLOCK) && level.getBlockState(blockpos.below().south().west()).is(RisusBlocks.CURVED_RITUAL_BLOCK) && level.getBlockState(blockpos.below()).is(RisusBlocks.BLOOD_FLUID_BLOCK)) {
            if (((Boolean)blockstate.getValue((Property)RisusCampfireBlock.LIT)).booleanValue() && blockstate.is(RisusBlocks.JOYFLAME_CAMPFIRE) && scythe.is((Item)RisusItems.SCYTHE.get())) {
                ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)RisusItems.CINDERGLEE_SCYTHE.get()));
                item.getItem().applyComponents(scythe.getComponentsPatch());
                player.level().addFreshEntity((Entity)item);
                if (!level.isClientSide()) {
                    level.setBlock(blockpos, (BlockState)((BlockState)((Block)RisusBlocks.JOYFLAME_CAMPFIRE.get()).defaultBlockState().setValue((Property)RisusCampfireBlock.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)RisusCampfireBlock.FACING, (Comparable)((Direction)blockstate.getValue((Property)RisusCampfireBlock.FACING))), 11);
                }
                scythe.shrink(1);
                if (level.isClientSide()) {
                    for (int i = 0; i < 20; ++i) {
                        level.addParticle((ParticleOptions)RisusParticles.ALTERATION_FINISHED.get(), (double)((float)blockpos.getX() - 1.0f + level.getRandom().nextFloat() * 2.75f), (double)blockpos.getY(), (double)((float)blockpos.getZ() - 1.0f + level.getRandom().nextFloat() * 2.75f), 0.0, (double)0.1f, 0.0);
                    }
                }
                level.playSound(null, blockpos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (((Boolean)blockstate.getValue((Property)CampfireBlock.LIT)).booleanValue() && blockstate.is(Blocks.SOUL_CAMPFIRE) && scythe.is((Item)RisusItems.SCYTHE.get())) {
                ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)RisusItems.SOUL_SCYTHE.get()));
                item.getItem().applyComponents(scythe.getComponentsPatch());
                if (scythe.getEnchantmentLevel((Holder)level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SMITE)) > 0) {
                    item.getItem();
                }
                player.level().addFreshEntity((Entity)item);
                if (!level.isClientSide()) {
                    level.setBlock(blockpos, (BlockState)((BlockState)Blocks.SOUL_CAMPFIRE.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)RisusCampfireBlock.FACING, (Comparable)((Direction)blockstate.getValue((Property)CampfireBlock.FACING))), 11);
                }
                scythe.shrink(1);
                if (level.isClientSide()) {
                    for (int i = 0; i < 20; ++i) {
                        level.addParticle((ParticleOptions)RisusParticles.ALTERATION_FINISHED.get(), (double)((float)blockpos.getX() - 1.0f + level.getRandom().nextFloat() * 2.75f), (double)blockpos.getY(), (double)((float)blockpos.getZ() - 1.0f + level.getRandom().nextFloat() * 2.75f), 0.0, (double)0.1f, 0.0);
                    }
                }
                level.playSound(null, blockpos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (((Boolean)blockstate.getValue((Property)CampfireBlock.LIT)).booleanValue() && blockstate.is(Blocks.CAMPFIRE) && scythe.is((Item)RisusItems.SCYTHE.get())) {
                ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)RisusItems.FIRE_SCYTHE.get()));
                item.getItem().applyComponents(scythe.getComponentsPatch());
                player.level().addFreshEntity((Entity)item);
                if (!level.isClientSide()) {
                    level.setBlock(blockpos, (BlockState)((BlockState)Blocks.CAMPFIRE.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)RisusCampfireBlock.FACING, (Comparable)((Direction)blockstate.getValue((Property)CampfireBlock.FACING))), 11);
                }
                scythe.shrink(1);
                if (level.isClientSide()) {
                    for (int i = 0; i < 20; ++i) {
                        level.addParticle((ParticleOptions)RisusParticles.ALTERATION_FINISHED.get(), (double)((float)blockpos.getX() - 1.0f + level.getRandom().nextFloat() * 2.75f), (double)blockpos.getY(), (double)((float)blockpos.getZ() - 1.0f + level.getRandom().nextFloat() * 2.75f), 0.0, (double)0.1f, 0.0);
                    }
                }
                level.playSound(null, blockpos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }
}

