/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items;

import com.bigdious.risus.Risus;
import com.bigdious.risus.entity.projectile.BloodSlash;
import com.bigdious.risus.init.RisusDamageTypes;
import com.bigdious.risus.init.RisusItems;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class ThousandBladeItem
extends SwordItem {
    public ThousandBladeItem(Tier material, Item.Properties properties) {
        super(material, properties);
    }

    public static ItemAttributeModifiers createThousandBladeAttributes(Tier tier, int damage, float speed) {
        return SwordItem.createAttributes((Tier)tier, (int)damage, (float)speed).withModifierAdded(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(Risus.prefix("knockback_res_modifier"), 0.1, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(Risus.prefix("range_modifier"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.MOVEMENT_SPEED, new AttributeModifier(Risus.prefix("speed_modifier"), (double)-0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.MAINHAND);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack material) {
        return material.is(RisusItems.GLUTTONY_SCALES);
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.SHARPNESS) || enchantment.is(Enchantments.BANE_OF_ARTHROPODS) || enchantment.is(Enchantments.SWEEPING_EDGE) || enchantment.is(Enchantments.LOOTING) || enchantment.is(Enchantments.SMITE) || enchantment.is(Enchantments.MENDING) || enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.KNOCKBACK) || enchantment.is(Enchantments.POWER) || enchantment.is(Enchantments.PIERCING) || enchantment.is(Enchantments.MULTISHOT) || enchantment.is(Enchantments.VANISHING_CURSE);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getDamageValue() >= itemstack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        player.startUsingItem(hand);
        itemstack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.SHARPNESS) || enchantment.is(Enchantments.SWEEPING_EDGE) || enchantment.is(Enchantments.BANE_OF_ARTHROPODS) || enchantment.is(Enchantments.LOOTING) || enchantment.is(Enchantments.SMITE) || enchantment.is(Enchantments.MENDING) || enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.KNOCKBACK) || enchantment.is(Enchantments.POWER) || enchantment.is(Enchantments.PIERCING) || enchantment.is(Enchantments.MULTISHOT) || enchantment.is(Enchantments.VANISHING_CURSE);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int useTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int i = this.getUseDuration(stack, entity) - useTicks;
            if (i >= 10) {
                if (!level.isClientSide()) {
                    if (stack.getEnchantmentLevel(level.registryAccess().holderOrThrow(Enchantments.MULTISHOT)) > 0) {
                        player.hurt(entity.damageSources().source(RisusDamageTypes.VAMPIRISM), 3.0f);
                        BloodSlash slash = new BloodSlash(level, (LivingEntity)player, stack);
                        BloodSlash slash1 = new BloodSlash(level, (LivingEntity)player, stack);
                        BloodSlash slash2 = new BloodSlash(level, (LivingEntity)player, stack);
                        slash.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.3f, 1.0f);
                        slash1.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + 10.0f, 0.0f, 1.3f, 1.0f);
                        slash2.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() - 10.0f, 0.0f, 1.3f, 1.0f);
                        level.addFreshEntity((Entity)slash);
                        level.addFreshEntity((Entity)slash1);
                        level.addFreshEntity((Entity)slash2);
                        level.playSound(null, (Entity)entity, SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.NEUTRAL, 1.0f, 0.6f);
                    } else {
                        player.hurt(entity.damageSources().source(RisusDamageTypes.VAMPIRISM), 1.0f);
                        BloodSlash slash = new BloodSlash(level, (LivingEntity)player, stack);
                        slash.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.3f, 1.0f);
                        level.addFreshEntity((Entity)slash);
                        level.playSound(null, (Entity)entity, SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.NEUTRAL, 1.0f, 0.6f);
                    }
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }
}

