/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items;

import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.init.RisusMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbility;

public class ToothknockerItem
extends SwordItem {
    public ToothknockerItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public boolean isValidRepairItem(ItemStack pToRepair, ItemStack pRepair) {
        return pRepair.is(RisusItems.GLUTTONY_SCALES);
    }

    public boolean mineBlock(ItemStack itemstack, Level p_43283_, BlockState p_43284_, BlockPos p_43285_, LivingEntity player) {
        if (p_43284_.getDestroySpeed((BlockGetter)p_43283_, p_43285_) != 0.0f) {
            itemstack.hurtAndBreak(1, player, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.SHARPNESS) || enchantment.is(Enchantments.BANE_OF_ARTHROPODS) || enchantment.is(Enchantments.SMITE) || enchantment.is(Enchantments.MENDING) || enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.FIRE_ASPECT) || enchantment.is(Enchantments.KNOCKBACK) || enchantment.is(Enchantments.LOOTING) || enchantment.is(Enchantments.VANISHING_CURSE);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.SHARPNESS) || enchantment.is(Enchantments.BANE_OF_ARTHROPODS) || enchantment.is(Enchantments.SMITE) || enchantment.is(Enchantments.MENDING) || enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.FIRE_ASPECT) || enchantment.is(Enchantments.KNOCKBACK) || enchantment.is(Enchantments.LOOTING) || enchantment.is(Enchantments.VANISHING_CURSE);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player.isHolding((Item)RisusItems.TOOTHKNOCKER.get()) && player.getOffhandItem().is((Item)RisusItems.TOOTHKNOCKER.get())) {
            player.addEffect(new MobEffectInstance(RisusMobEffects.TOOTHLUSTER, 0, 0, false, false, false));
            player.getOffhandItem().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.OFFHAND);
            player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            Level level = player.level();
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TURTLE_EGG_BREAK, SoundSource.PLAYERS, 0.5f, 1.0f);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player player, InteractionHand pHand) {
        ItemStack itemstack = player.getItemInHand(pHand);
        if (itemstack.getDamageValue() >= itemstack.getMaxDamage() - 1 || player.isFallFlying() || player.isInWater()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        float f7 = player.getYRot();
        float f = player.getXRot();
        float f1 = -Mth.sin((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float f2 = -Mth.sin((float)(f * ((float)Math.PI / 180)));
        float f3 = Mth.cos((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float f4 = Mth.sqrt((float)(f1 * f1 + f2 * f2 + f3 * f3));
        float f5 = 0.75f;
        player.push((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
        player.move(MoverType.PISTON, new Vec3(0.0, 1.1999999284744263, 0.0));
        player.getCooldowns().addCooldown((Item)this, 30);
        itemstack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return false;
    }
}

