/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items.armor;

import com.bigdious.risus.init.RisusItems;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class RisusArmorItem
extends ArmorItem {
    public RisusArmorItem(Holder<ArmorMaterial> armorMaterial, ArmorItem.Type type, Item.Properties properties) {
        super(armorMaterial, type, properties);
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.is((Item)RisusItems.SKIN_BOOTS.get());
    }

    public static ItemAttributeModifiers createSkinAttributes(ArmorItem.Type type, int armor) {
        ResourceLocation armorLocation = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        EquipmentSlotGroup group = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        return ItemAttributeModifiers.builder().add(Attributes.ARMOR, new AttributeModifier(armorLocation, (double)armor, AttributeModifier.Operation.ADD_VALUE), group).add(Attributes.MAX_HEALTH, new AttributeModifier(armorLocation, 5.0, AttributeModifier.Operation.ADD_VALUE), group).build();
    }
}

