/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.world.level;

import com.bigdious.risus.entity.Weaver;
import com.bigdious.risus.init.RisusEntities;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public class WeaverNestHelper {
    private int spawnDelay;
    public final int maxNearbyEntities = 10;
    public final int requiredPlayerRange = 32;
    public final int spawnRange = 10;

    private boolean isNearPlayer(Level pLevel, BlockPos pPos) {
        return pLevel.hasNearbyAlivePlayer((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, (double)this.requiredPlayerRange);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos) {
        if (this.isNearPlayer((Level)level, pos)) {
            EntityTypeTest entityTypeTest = EntityTypeTest.forExactClass(Weaver.class);
            AABB aABB = new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1));
            Objects.requireNonNull(this);
            int k = level.getEntities(entityTypeTest, aABB.inflate(10.0), EntitySelector.NO_SPECTATORS).size();
            Objects.requireNonNull(this);
            if (k >= 10) {
                return;
            }
            if (this.spawnDelay > 1200) {
                Weaver weaver = (Weaver)((EntityType)RisusEntities.WEAVER.get()).create((Level)level);
                weaver.moveTo(pos.getCenter().x, pos.getBottomCenter().y, pos.getCenter().z, 0.0f, 0.0f);
                level.addFreshEntity((Entity)weaver);
                this.spawnDelay = 0;
            } else {
                ++this.spawnDelay;
            }
        }
    }
}

