/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.entity;

import com.jdolphin.ricksportalgun.common.init.PGDamageTypes;
import com.jdolphin.ricksportalgun.common.init.PGEntities;
import com.jdolphin.ricksportalgun.common.init.PGSounds;
import com.jdolphin.ricksportalgun.common.util.helpers.LevelHelper;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2709;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7260;

public class PortalEntity
extends class_1297 {
    public static final String TAG_DIMENSION = "PortalDimension";
    public static final String TAG_BPOS = "PortalPos";
    public static final String TAG_NEW = "isSpawned";
    public static final String TAG_COLOR = "Color";
    private String dim;
    private Optional<class_2338> pos;
    private boolean bootleg;
    private int wait;
    private int lifetime;
    private boolean exists;
    public static final class_2940<String> DIM = class_2945.method_12791(PortalEntity.class, (class_2941)class_2943.field_13326);
    public static final class_2940<class_2338> POS = class_2945.method_12791(PortalEntity.class, (class_2941)class_2943.field_13324);
    public static final class_2940<Integer> COLOR = class_2945.method_12791(PortalEntity.class, (class_2941)class_2943.field_13327);

    public PortalEntity(class_1937 pLevel) {
        super(PGEntities.PORTAL, pLevel);
    }

    public PortalEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DIM, (Object)this.method_37908().method_27983().method_29177().toString());
        builder.method_56912(POS, (Object)this.method_24515());
        builder.method_56912(COLOR, (Object)Color.GREEN.getRGB());
    }

    public void setColor(int color) {
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(COLOR);
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean isBootleg() {
        return this.bootleg;
    }

    public void setBootleg(boolean acid) {
        this.bootleg = acid;
    }

    public void setPos(class_2338 pos) {
        this.method_23327(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    protected void method_5749(class_2487 tag) {
        this.dim = tag.method_10558(TAG_DIMENSION);
        this.exists = tag.method_10577(TAG_NEW);
        this.pos = class_2512.method_10691((class_2487)tag, (String)TAG_BPOS);
        this.setColor(tag.method_10550(TAG_COLOR));
    }

    protected void method_5652(class_2487 tag) {
        tag.method_10582(TAG_DIMENSION, this.getHopDim());
        tag.method_10566(TAG_BPOS, class_2512.method_10692((class_2338)this.getHopLoc()));
        tag.method_10556(TAG_NEW, this.exists);
        tag.method_10569(TAG_COLOR, this.getColor());
    }

    public void setHopLocation(class_2960 dimension, class_2338 pos) {
        this.dim = dimension.toString();
        this.pos = Optional.of(pos);
    }

    public class_2338 getHopLoc() {
        return this.pos.orElse(class_2338.field_10980);
    }

    public String getHopDim() {
        return this.dim != null ? this.dim : "minecraft:overworld";
    }

    public static List<class_1297> getEntitiesNearby(class_1297 entity) {
        class_238 boundingBox = entity.method_5829();
        List entities = entity.method_37908().method_18467(class_1297.class, boundingBox.method_996(entity.method_24515()));
        entities.remove(entity);
        entities.removeIf(e -> e instanceof PortalEntity);
        entities.removeIf(e -> e instanceof class_1510);
        entities.removeIf(e -> e instanceof class_1528);
        entities.removeIf(e -> e instanceof class_7260);
        entities.removeIf(e -> {
            if (e instanceof class_1657) {
                class_1657 player = (class_1657)e;
                return !player.method_5822(false);
            }
            return false;
        });
        return entities;
    }

    public void method_5768(class_3218 world) {
        this.method_5650(class_1297.class_5529.field_26999);
        this.method_32876((class_6880)class_5712.field_37676);
    }

    public void method_5710(float yaw, float pitch) {
        super.method_5710(yaw, pitch);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.lifetime = 200;
            if (!this.exists) {
                LevelHelper.playSound(this.method_37908(), this.method_24515(), PGSounds.PORTAL_SHOOT, class_3419.field_15248);
            }
            this.exists = true;
            ++this.wait;
            if (this.field_6012 > this.lifetime) {
                this.method_5768((class_3218)this.method_37908());
                return;
            }
            List<class_1297> entityList = PortalEntity.getEntitiesNearby(this);
            if (!entityList.isEmpty()) {
                for (class_1297 nearby : entityList) {
                    if (!this.bootleg) {
                        class_5321<class_1937> key = LevelHelper.getWorldKey(this.getHopDim());
                        class_3218 serverlevel = LevelHelper.getServerWorld(this.method_37908(), key);
                        class_2338 pos = this.getHopLoc();
                        if (nearby.equals((Object)this) || nearby.method_5782() || nearby.method_5765() || serverlevel == null || !nearby.method_5822(true) || this.wait <= 5) continue;
                        serverlevel.method_17988(pos.method_10263(), pos.method_10260(), true);
                        class_243 look = class_243.method_1034((class_241)new class_241(45.0f, this.method_36454() - 180.0f));
                        double distance = 2.0;
                        double dx = (double)pos.method_10263() - look.field_1352 * distance;
                        double dz = (double)pos.method_10260() - look.field_1350 * distance;
                        Set set = class_2709.method_63641((Set[])new Set[]{class_2709.field_54094, class_2709.field_40711});
                        nearby.method_48105(serverlevel, dx, (double)pos.method_10264(), dz, set, this.method_36454(), nearby.method_36455(), false);
                        serverlevel.method_17988(pos.method_10263(), pos.method_10260(), false);
                        this.wait = 0;
                        continue;
                    }
                    nearby.method_64397((class_3218)this.method_37908(), PGDamageTypes.of(this.method_37908(), PGDamageTypes.BOOTLEG), 2.1474836E9f);
                }
            }
        }
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return false;
    }
}

