/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.item;

import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGEntities;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.util.PortalGunType;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9334;

public class PortalGunItem
extends class_1792 {
    public PortalGunItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static int getMaxFuel(class_1799 stack) {
        return 16;
    }

    public static int getFuel(class_1799 stack) {
        return (Integer)stack.method_57825(PGDataComponents.FUEL, (Object)((Integer)stack.method_57825(PGDataComponents.MAX_FUEL, (Object)16)));
    }

    public int method_31571(class_1799 stack) {
        return (Integer)stack.method_57825(PGDataComponents.PORTAL_COLOUR, (Object)(stack.method_31574(PGItems.GOLDEN_PORTAL_GUN) ? Color.YELLOW.getRGB() : Color.GREEN.getRGB()));
    }

    public static void lowerFuel(class_1799 stack, int amount) {
        int i = PortalGunItem.getFuel(stack);
        stack.method_57379(PGDataComponents.FUEL, (Object)Math.max(0, i - amount));
    }

    public static void refillFuel(class_1799 stack) {
        stack.method_57379(PGDataComponents.FUEL, (Object)PortalGunItem.getMaxFuel(stack));
    }

    public boolean refuel(class_1799 stack, class_1657 player) {
        class_1799 offhand = player.method_6079();
        class_1799 mainHand = player.method_6047();
        if (PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(stack) && mainHand.method_31573(PGTags.Items.PORTAL_GUNS)) {
            if (offhand.method_31574(PGItems.PORTAL_FLUID_BOTTLE)) {
                PortalGunItem.refillFuel(stack);
                offhand.method_7934(1);
                stack.method_57379(PGDataComponents.BOOTLEG, (Object)false);
                return true;
            }
            if (offhand.method_31574(PGItems.BOOTLEG_PORTAL_FLUID_BOTTLE)) {
                PortalGunItem.refillFuel(stack);
                stack.method_57379(PGDataComponents.BOOTLEG, (Object)true);
                offhand.method_7934(1);
                return true;
            }
        }
        return false;
    }

    public void setPortalGunType(class_1799 stack, PortalGunType type) {
        stack.method_57379(PGDataComponents.PORTAL_GUN_TYPES, (Object)type);
        stack.method_57379(class_9334.field_54199, (Object)type.getModelLocation());
        stack.method_57379(class_9334.field_50239, (Object)type.getName());
    }

    public class_1269 method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_3965 hitResult = PortalGunItem.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1347);
        if (!level.method_8608() && player instanceof class_3222 && !this.refuel(stack, player) && PortalGunItem.getFuel(stack) > 0) {
            PortalEntity portal = (PortalEntity)PGEntities.PORTAL.method_5883(level, class_3730.field_16465);
            PortalEntity exPortal = (PortalEntity)PGEntities.PORTAL.method_5883(level, class_3730.field_16465);
            if (portal != null && exPortal != null) {
                exPortal.setPos(PortalGunItem.getHopCoords(stack));
                class_243 loc = hitResult.method_17784();
                if (hitResult.method_17783().equals((Object)class_239.class_240.field_1332)) {
                    class_2350 dir = hitResult.method_17780();
                    class_2338 bPos = hitResult.method_17777();
                    if (level.method_8320(bPos.method_10084()).equals(class_2246.field_10124.method_9564()) && dir == class_2350.field_11036) {
                        portal.method_23327(loc.method_10216(), loc.method_10214(), loc.method_10215());
                    }
                    if (level.method_8320(bPos.method_10074()).equals(class_2246.field_10124.method_9564()) && dir == class_2350.field_11033) {
                        portal.method_23327(loc.method_10216(), loc.method_10214() - 2.0, loc.method_10215());
                    }
                    if (dir == class_2350.field_11043) {
                        if (level.method_8320(bPos.method_10095()).equals(class_2246.field_10124.method_9564())) {
                            portal.method_23327((double)bPos.method_10263() + 0.5, bPos.method_10264() - 1, (double)bPos.method_10260() - 0.5);
                        } else {
                            portal.method_23327(loc.method_10216(), bPos.method_10264() - 1, loc.method_10215());
                        }
                    }
                    if (dir == class_2350.field_11035) {
                        if (level.method_8320(bPos.method_10072()).equals(class_2246.field_10124.method_9564())) {
                            portal.method_23327((double)bPos.method_10263() + 0.5, bPos.method_10264() - 1, (double)bPos.method_10260() + 1.5);
                        } else {
                            portal.method_23327(loc.method_10216(), bPos.method_10264() - 1, loc.method_10215());
                        }
                    }
                    if (dir == class_2350.field_11039) {
                        if (level.method_8320(bPos.method_10067()).equals(class_2246.field_10124.method_9564())) {
                            portal.method_23327((double)bPos.method_10263() - 0.5, bPos.method_10264() - 1, (double)bPos.method_10260() + 0.5);
                        } else {
                            portal.method_23327(loc.method_10216(), bPos.method_10264() - 1, loc.method_10215());
                        }
                    }
                    if (dir == class_2350.field_11034) {
                        if (level.method_8320(bPos.method_10078()).equals(class_2246.field_10124.method_9564())) {
                            portal.method_23327((double)bPos.method_10263() + 1.5, bPos.method_10264() - 1, (double)bPos.method_10260() + 0.5);
                        } else {
                            portal.method_23327(loc.method_10216(), bPos.method_10264() - 1, loc.method_10215());
                        }
                    }
                } else {
                    portal.method_23327(loc.method_10216(), loc.method_10214() - 1.0, loc.method_10215());
                }
                class_5321 resourcekey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)((class_2960)stack.method_57824(PGDataComponents.PORTAL_DIM)));
                class_3218 serverlevel = ((class_3218)level).method_8503().method_3847(resourcekey);
                portal.setHopLocation(PortalGunItem.getHopDimension(stack), PortalGunItem.getHopCoords(stack));
                exPortal.setHopLocation(level.method_27983().method_29177(), portal.method_24515());
                if (((Boolean)stack.method_57825(PGDataComponents.BOOTLEG, (Object)false)).booleanValue()) {
                    portal.setBootleg(true);
                    exPortal.setBootleg(true);
                } else if (((Boolean)stack.method_57825(PGDataComponents.BOOTLEG, (Object)false)).booleanValue()) {
                    portal.setBootleg(false);
                    exPortal.setBootleg(false);
                }
                portal.setColor(this.getColor(stack));
                exPortal.setColor(this.getColor(stack));
                portal.method_5710(player.method_5791(), 0.0f);
                exPortal.method_5710(player.method_5791(), 0.0f);
                if (serverlevel != null) {
                    serverlevel.method_8649((class_1297)exPortal);
                    level.method_8649((class_1297)portal);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)"Error: Destination level is null").method_27692(class_124.field_1061), false);
                }
                player.method_7342(class_3468.field_15372.method_14956((Object)this), 1);
                player.method_7357().method_62835(stack, 60);
                if (!player.method_7337()) {
                    stack.method_61653(1, player);
                }
            }
        }
        return class_1269.field_5811;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        class_2338 pos = PortalGunItem.getHopCoords(stack);
        tooltip.add((class_2561)class_2561.method_43469((String)"item.ricksportalgun.portalgun.tooltip.destination", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.ricksportalgun.portalgun.tooltip.dimension", (Object[])new Object[]{PortalGunItem.getHopDimension(stack).toString()}).method_27692(class_124.field_1080));
    }

    public int getColor(class_1799 stack) {
        return (Integer)stack.method_57825(PGDataComponents.PORTAL_COLOUR, (Object)(stack.method_7909().equals(PGItems.GOLDEN_PORTAL_GUN) ? Color.YELLOW.getRGB() : Color.GREEN.getRGB()));
    }

    public void setColor(class_1799 stack, int color) {
        stack.method_57379(PGDataComponents.PORTAL_COLOUR, (Object)color);
    }

    public void addWaypoint(class_1799 stack, Waypoint waypoint) {
        List component = (List)stack.method_57825(PGDataComponents.WAYPOINTS, List.of());
        ArrayList<Waypoint> list = new ArrayList<Waypoint>(component);
        list.add(waypoint);
        stack.method_57379(PGDataComponents.WAYPOINTS, list);
    }

    public void deleteWaypoint(class_1799 stack, Waypoint waypoint) {
        List component = (List)stack.method_57825(PGDataComponents.WAYPOINTS, List.of());
        ArrayList list = new ArrayList(component);
        list.remove(waypoint);
        stack.method_57379(PGDataComponents.WAYPOINTS, list);
    }

    public static List<Waypoint> getWaypoints(class_1799 stack) {
        return (List)stack.method_57825(PGDataComponents.WAYPOINTS, List.of());
    }

    public void setHopLocation(class_1799 stack, String dimension, class_2338 pos) {
        stack.method_57379(PGDataComponents.PORTAL_DIM, (Object)class_2960.method_60654((String)dimension));
        stack.method_57379(PGDataComponents.PORTAL_POS, (Object)pos);
    }

    public static class_2960 getHopDimension(class_1799 stack) {
        if (!stack.method_57826(PGDataComponents.PORTAL_DIM)) {
            stack.method_57379(PGDataComponents.PORTAL_DIM, (Object)class_1937.field_25179.method_29177());
        }
        return (class_2960)stack.method_57824(PGDataComponents.PORTAL_DIM);
    }

    public static class_2338 getHopCoords(class_1799 stack) {
        if (!stack.method_57826(PGDataComponents.PORTAL_POS)) {
            stack.method_57379(PGDataComponents.PORTAL_POS, (Object)class_2338.field_10980);
            return class_2338.field_10980;
        }
        return (class_2338)stack.method_57824(PGDataComponents.PORTAL_POS);
    }
}

