/*
 * Decompiled with CFR 0.152.
 */
package com.laidbacksloth42.placementutil.item.custom;

import com.google.common.collect.Multimap;
import com.laidbacksloth42.placementutil.config.ModCommonConfigs;
import com.laidbacksloth42.placementutil.item.ModItems;
import com.laidbacksloth42.placementutil.util.Util;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="placementutil")
public class AngelWandItem
extends Item {
    private static final UUID RANGE_TUNING_MODIFIER_UUID = UUID.fromString("91d99148-783a-4bf5-b656-11924dbe77cf");

    public AngelWandItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        if (Screen.m_96637_() && Screen.m_96638_()) {
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.placementutil.item.angel_wand"));
        } else {
            int rangeValue = pStack.m_41784_().m_128451_("placementutil_angel_range");
            boolean breakValue = pStack.m_41784_().m_128471_("placementutil_angel_break");
            boolean rotateValue = pStack.m_41784_().m_128471_("placementutil_angel_rotate");
            int maxRange = (Integer)ModCommonConfigs.ANGEL_MODIFIER_RANGE_MAX.get();
            String angelRange = "Range: " + (rangeValue == 0 ? "\u00a7c" : (rangeValue == maxRange ? "\u00a7a" : "\u00a7e")) + rangeValue + " / " + maxRange;
            String angelBreak = "Break: " + (breakValue ? "\u00a7a" : "\u00a7c") + breakValue;
            String angelRotate = "Rotate: " + (rotateValue ? "\u00a7a" : "\u00a7c") + rotateValue;
            pTooltip.add((Component)Component.m_237113_((String)angelRange));
            pTooltip.add((Component)Component.m_237113_((String)angelBreak));
            pTooltip.add((Component)Component.m_237113_((String)angelRotate));
            pTooltip.add((Component)Component.m_237119_());
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.placementutil.info"));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        if (!pLevel.f_46443_ && pUsedHand == InteractionHand.OFF_HAND) {
            Item held = pPlayer.m_21205_().m_41720_();
            if (!(held instanceof BlockItem)) {
                return super.m_7203_(pLevel, pPlayer, pUsedHand);
            }
            BlockHitResult blockHitResult = Util.getPlayerPOVHitResult(pPlayer);
            BlockPos pos = Util.getAdvancedPositionFromBlockHitResult(blockHitResult, pPlayer);
            if (pos == null) {
                return super.m_7203_(pLevel, pPlayer, pUsedHand);
            }
            Block block = ((BlockItem)held).m_40614_();
            if (block instanceof DoorBlock || block instanceof BedBlock || pPlayer.f_19853_.m_8055_(pos).m_60734_() == block) {
                return super.m_7203_(pLevel, pPlayer, pUsedHand);
            }
            BlockState newState = Util.getPlacingBlockStateFromPlayer(pPlayer, block);
            if (!newState.m_60710_((LevelReader)pPlayer.f_19853_, pos)) {
                return super.m_7203_(pLevel, pPlayer, pUsedHand);
            }
            pLevel.m_7731_(pos, newState, 3);
            if (!pPlayer.m_7500_()) {
                pPlayer.m_150109_().m_182403_(false);
            }
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    @SubscribeEvent
    public static void holdingAngelWandIncreasesRangeAndGivesMiningFatigue(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.f_19853_.f_46443_) {
            return;
        }
        CompoundTag persistentData = player.getPersistentData();
        boolean holdingAngelWand = player.m_21206_().m_41720_() == ModItems.ANGEL_WAND.get();
        boolean wasHoldingAngelWand = persistentData.m_128441_("placementutilAngelWand");
        int amount = 0;
        if (player.m_21206_().m_41720_() == ModItems.ANGEL_WAND.get()) {
            amount = player.m_21206_().m_41784_().m_128451_("placementutil_angel_range");
            if (persistentData.m_128451_("placementutil_angel_range_last") != amount) {
                holdingAngelWand = false;
                wasHoldingAngelWand = true;
                persistentData.m_128405_("placementutil_angel_range_last", amount);
            }
        }
        Supplier<Multimap<Attribute, AttributeModifier>> rangeModifier = Util.getRangeModifier(amount);
        if (!persistentData.m_128441_("placementutilAngelModifier")) {
            persistentData.m_128347_("placementutilAngelModifier", 0.0);
        }
        Supplier<Multimap<Attribute, AttributeModifier>> rangeTuningModifier = Util.getRangeTuningModifier(persistentData.m_128459_("placementutilAngelModifier"));
        if (holdingAngelWand != wasHoldingAngelWand) {
            if (!holdingAngelWand) {
                player.m_21204_().m_22161_(rangeModifier.get());
                if (player.m_21204_().m_22154_((Attribute)ForgeMod.REACH_DISTANCE.get(), RANGE_TUNING_MODIFIER_UUID)) {
                    player.m_21204_().m_22161_(rangeTuningModifier.get());
                }
                persistentData.m_128473_("placementutilAngelWand");
            } else {
                player.m_21204_().m_22178_(rangeModifier.get());
                if (persistentData.m_128441_("placementutilAngelModifier")) {
                    player.m_21204_().m_22178_(rangeTuningModifier.get());
                }
                persistentData.m_128379_("placementutilAngelWand", true);
            }
        }
        if (player.m_21206_().m_41720_() == ModItems.ANGEL_WAND.get() && !player.m_21206_().m_41784_().m_128471_("placementutil_angel_break")) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 30, 2, false, false, false));
        }
    }

    @SubscribeEvent
    public static void addReachToJoiningPlayersHoldingAngelWand(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player.f_19853_.f_46443_) {
            return;
        }
        CompoundTag persistentData = player.getPersistentData();
        int amount = 0;
        if (player.m_21206_().m_41720_() == ModItems.ANGEL_WAND.get()) {
            amount = player.m_21206_().m_41784_().m_128451_("placementutil_angel_range");
        }
        Supplier<Multimap<Attribute, AttributeModifier>> rangeModifier = Util.getRangeModifier(amount);
        if (!persistentData.m_128441_("placementutilAngelModifier")) {
            persistentData.m_128347_("placementutilAngelModifier", 0.0);
        }
        Supplier<Multimap<Attribute, AttributeModifier>> rangeTuningModifier = Util.getRangeTuningModifier(persistentData.m_128459_("placementutilAngelModifier"));
        if (persistentData.m_128441_("placementutilAngelWand")) {
            player.m_21204_().m_22178_(rangeModifier.get());
            if (persistentData.m_128459_("placementutilAngelModifier") != 0.0) {
                player.m_21204_().m_22178_(rangeTuningModifier.get());
            }
        }
    }
}

