/*
 * Decompiled with CFR 0.152.
 */
package com.laidbacksloth42.placementutil.networking;

import com.google.common.collect.Multimap;
import com.laidbacksloth42.placementutil.util.Util;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundAngelWandReachPacket {
    private static final UUID RANGE_TUNING_MODIFIER_UUID = UUID.fromString("91d99148-783a-4bf5-b656-11924dbe77cf");
    public final boolean reverse;

    public ServerboundAngelWandReachPacket(boolean reverse) {
        this.reverse = reverse;
    }

    public ServerboundAngelWandReachPacket(FriendlyByteBuf buffer) {
        this(buffer.readBoolean());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.reverse);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            double modifierValue = player.m_21204_().m_22154_((Attribute)ForgeMod.REACH_DISTANCE.get(), RANGE_TUNING_MODIFIER_UUID) ? player.m_21204_().m_22173_((Attribute)ForgeMod.REACH_DISTANCE.get(), RANGE_TUNING_MODIFIER_UUID) : 0.0;
            double baseValue = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())).m_22135_();
            double amount = this.reverse ? (baseValue > 2.0 ? modifierValue - 1.0 : 1.0 + modifierValue - baseValue) : (modifierValue < -1.0 ? modifierValue + 1.0 : 0.0);
            Supplier<Multimap<Attribute, AttributeModifier>> rangeTuningModifier = Util.getRangeTuningModifier(amount);
            if (player.m_21204_().m_22154_((Attribute)ForgeMod.REACH_DISTANCE.get(), RANGE_TUNING_MODIFIER_UUID)) {
                player.m_21204_().m_22161_(rangeTuningModifier.get());
            }
            player.getPersistentData().m_128347_("placementutilAngelModifier", amount);
            player.m_21204_().m_22178_(rangeTuningModifier.get());
        });
        ctx.get().setPacketHandled(true);
    }
}

