/*
 * Decompiled with CFR 0.152.
 */
package com.laidbacksloth42.placementutil.networking;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundAngelWandRotatingPacket {
    public final BlockPos blockPos;

    public ServerboundAngelWandRotatingPacket(BlockPos pos) {
        this.blockPos = pos;
    }

    public ServerboundAngelWandRotatingPacket(FriendlyByteBuf buffer) {
        this(buffer.m_130135_());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.blockPos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockState state = player.f_19853_.m_8055_(this.blockPos);
            if (!this.canRotate(state)) {
                return;
            }
            BlockState newState = null;
            if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
                Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
                newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)(axis == Direction.Axis.X ? Direction.Axis.Y : (axis == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.X)));
            } else if (state.m_61138_((Property)BlockStateProperties.f_61402_)) {
                newState = state.m_61138_((Property)BlockStateProperties.f_61374_) && !player.m_6144_() ? (state.m_61143_((Property)BlockStateProperties.f_61402_) == Half.BOTTOM ? (state.m_61143_((Property)BlockStateProperties.f_61374_) == Direction.WEST ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)Half.TOP) : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122427_())) : (state.m_61143_((Property)BlockStateProperties.f_61374_) == Direction.NORTH ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)Half.BOTTOM) : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122428_()))) : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)(state.m_61143_((Property)BlockStateProperties.f_61402_) == Half.BOTTOM ? Half.TOP : Half.BOTTOM));
            } else if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                if (player.m_6144_()) {
                    newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_());
                } else {
                    newState = state;
                    for (int i = 0; i < 4 && !(newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)newState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122427_())).m_60710_((LevelReader)player.f_19853_, this.blockPos); ++i) {
                    }
                }
            } else if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
                newState = player.m_6144_() ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction.m_122424_()) : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)(direction == Direction.WEST ? Direction.UP : (direction == Direction.UP ? Direction.DOWN : (direction == Direction.DOWN ? Direction.NORTH : direction.m_122427_()))));
            } else if (state.m_61138_((Property)BlockStateProperties.f_61397_) && state.m_61143_((Property)BlockStateProperties.f_61397_) != SlabType.DOUBLE) {
                newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)(state.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM));
            }
            if (newState != null && newState.m_60710_((LevelReader)player.f_19853_, this.blockPos)) {
                player.f_19853_.m_7731_(this.blockPos, newState, 3);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private boolean canRotate(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof PistonHeadBlock || block instanceof BedBlock) {
            return false;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61432_)) {
            return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61432_) == false;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61392_)) {
            return state.m_61143_((Property)BlockStateProperties.f_61392_) == ChestType.SINGLE;
        }
        return true;
    }
}

