/*
 * Decompiled with CFR 0.152.
 */
package com.laidbacksloth42.placementutil.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class Util {
    public static BlockHitResult getPlayerPOVHitResult(Player player) {
        Vec3 vecEye = player.m_146892_();
        float f2 = Mth.m_14089_((float)(-player.m_146908_() * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-player.m_146908_() * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-player.m_146909_() * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-player.m_146909_() * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double reach = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())).m_22135_();
        Vec3 vecBlock = vecEye.m_82520_((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        return player.f_19853_.m_45547_(new ClipContext(vecEye, vecBlock, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
    }

    public static BlockPos getAdvancedPositionFromBlockHitResult(BlockHitResult blockHitResult, Player player) {
        if (player.f_19853_.m_8055_(blockHitResult.m_82425_()).m_60767_().m_76336_()) {
            return blockHitResult.m_82425_();
        }
        if (player.f_19853_.m_8055_(blockHitResult.m_82425_().m_142300_(blockHitResult.m_82434_())).m_60767_().m_76336_()) {
            return blockHitResult.m_82425_().m_142300_(blockHitResult.m_82434_());
        }
        return null;
    }

    public static BlockState getPlacingBlockStateFromPlayer(Player player, Block block) {
        BlockState newState;
        BlockState state = block.m_49966_();
        if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)(Math.abs(player.m_146909_()) > 45.0f ? Direction.Axis.Y : player.m_6350_().m_122434_()));
        } else if (state.m_61138_((Property)BlockStateProperties.f_61402_)) {
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)(player.m_146909_() > 0.0f ? Half.BOTTOM : Half.TOP));
            if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)player.m_6350_());
            }
        } else if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)player.m_6350_().m_122424_());
        } else if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            Direction direction = player.m_146909_() > 45.0f ? Direction.DOWN : (player.m_146909_() < -45.0f ? Direction.UP : player.m_6350_());
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction.m_122424_());
        } else {
            newState = state.m_61138_((Property)BlockStateProperties.f_61397_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)(player.m_146909_() > 0.0f ? SlabType.BOTTOM : SlabType.TOP)) : state;
        }
        return newState;
    }

    public static Supplier<Multimap<Attribute, AttributeModifier>> getRangeModifier(double amount) {
        AttributeModifier rangeAttributeModifier = new AttributeModifier(UUID.fromString("a72ae76c-a73b-4eb6-8670-096aa38facd4"), "Range modifier", amount, AttributeModifier.Operation.ADDITION);
        return Suppliers.memoize(() -> ImmutableMultimap.of((Object)((Attribute)ForgeMod.REACH_DISTANCE.get()), (Object)rangeAttributeModifier));
    }

    public static Supplier<Multimap<Attribute, AttributeModifier>> getRangeTuningModifier(double amount) {
        AttributeModifier rangeTuningAttributeModifier = new AttributeModifier(UUID.fromString("91d99148-783a-4bf5-b656-11924dbe77cf"), "Range Tuning Modifier", amount, AttributeModifier.Operation.ADDITION);
        return Suppliers.memoize(() -> ImmutableMultimap.of((Object)((Attribute)ForgeMod.REACH_DISTANCE.get()), (Object)rangeTuningAttributeModifier));
    }
}

