/*
 * Decompiled with CFR 0.152.
 */
package cyborgcabbage.amethystgravity.block;

import com.google.common.collect.ImmutableMap;
import cyborgcabbage.amethystgravity.AmethystGravity;
import cyborgcabbage.amethystgravity.block.entity.PlatingBlockEntity;
import cyborgcabbage.amethystgravity.gravity.GravityEffect;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class PlatingBlock
extends class_2237 {
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 DOWN = class_2741.field_12546;
    protected static final class_265 DOWN_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final class_265 UP_SHAPE = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final class_265 WEST_SHAPE = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 EAST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private final Map<class_2680, class_265> shapesByState;
    public final double GRAVITY_EFFECT_HEIGHT;

    public PlatingBlock(double height, class_4970.class_2251 settings) {
        super(settings);
        this.GRAVITY_EFFECT_HEIGHT = height;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false)));
        this.shapesByState = ImmutableMap.copyOf(this.field_10647.method_11662().stream().collect(Collectors.toMap(Function.identity(), PlatingBlock::getShapeForState)));
    }

    private static class_265 getShapeForState(class_2680 state) {
        class_265 voxelShape = class_259.method_1073();
        if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
            voxelShape = UP_SHAPE;
        }
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)SOUTH_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)NORTH_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)WEST_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)EAST_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)DOWN)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)DOWN_SHAPE);
        }
        return voxelShape.method_1110() ? class_259.method_1077() : voxelShape;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapesByState.get(state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{UP, DOWN, NORTH, SOUTH, EAST, WEST});
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)PlatingBlock.directionToProperty(direction))).booleanValue() && !this.canPlaceOn((class_1922)world, pos.method_10093(direction), direction.method_10153())) {
            if (PlatingBlock.getDirections(state = (class_2680)state.method_11657((class_2769)PlatingBlock.directionToProperty(direction), (Comparable)Boolean.valueOf(false))).size() == 0) {
                return class_2246.field_10124.method_9564();
            }
            return state;
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11464: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
            case field_11465: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11463: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)));
            }
        }
        return state;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        switch (mirror) {
            case field_11300: {
                return (class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11301: {
                return (class_2680)((class_2680)state.method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
        }
        return super.method_9569(state, mirror);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PlatingBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.field_9236) {
            return PlatingBlock.method_31618(type, AmethystGravity.PLATING_BLOCK_ENTITY, PlatingBlockEntity::clientTick);
        }
        return PlatingBlock.method_31618(type, AmethystGravity.PLATING_BLOCK_ENTITY, PlatingBlockEntity::serverTick);
    }

    public boolean method_9616(class_2680 state, class_1750 context) {
        if (!context.method_8046() && context.method_8041().method_7909() == this.method_8389()) {
            return (Boolean)state.method_11654((class_2769)PlatingBlock.directionToProperty(context.method_8038().method_10153())) == false;
        }
        return super.method_9616(state, context);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037());
        if (blockState.method_27852((class_2248)this)) {
            return (class_2680)blockState.method_11657((class_2769)PlatingBlock.directionToProperty(ctx.method_8038().method_10153()), (Comparable)Boolean.valueOf(true));
        }
        return (class_2680)this.method_9564().method_11657((class_2769)PlatingBlock.directionToProperty(ctx.method_8038().method_10153()), (Comparable)Boolean.valueOf(true));
    }

    private boolean canPlaceOn(class_1922 world, class_2338 pos, class_2350 side) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26206(world, pos, side);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        ArrayList<class_2350> directions = PlatingBlock.getDirections(state);
        if (directions.size() == 1) {
            return this.canPlaceOn((class_1922)world, pos.method_10093(directions.get(0)), directions.get(0).method_10153());
        }
        if (directions.size() > 1) {
            for (class_2350 dir : PlatingBlock.getDirections(world.method_8320(pos))) {
                directions.remove(dir);
            }
            return this.canPlaceOn((class_1922)world, pos.method_10093(directions.get(0)), directions.get(0).method_10153());
        }
        return false;
    }

    public static class_2746 directionToProperty(class_2350 direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> DOWN;
            case class_2350.field_11036 -> UP;
            case class_2350.field_11043 -> NORTH;
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11039 -> WEST;
            case class_2350.field_11034 -> EAST;
        };
    }

    public static ArrayList<class_2350> getDirections(class_2680 blockState) {
        ArrayList<class_2350> list = new ArrayList<class_2350>();
        for (int directionId = 0; directionId < 6; ++directionId) {
            class_2350 direction = class_2350.method_10143((int)directionId);
            if (!((Boolean)blockState.method_11654((class_2769)PlatingBlock.directionToProperty(direction))).booleanValue()) continue;
            list.add(direction);
        }
        return list;
    }

    public GravityEffect getGravityEffect(class_2350 direction, class_2338 blockPos) {
        return new GravityEffect(direction, this.GRAVITY_EFFECT_HEIGHT * 1.0 * 1.0, blockPos);
    }

    public class_238 getGravityEffectBox(class_2338 blockPos, class_2350 direction) {
        double minX = blockPos.method_10263();
        double minY = blockPos.method_10264();
        double minZ = blockPos.method_10260();
        double maxX = blockPos.method_10263() + 1;
        double maxY = blockPos.method_10264() + 1;
        double maxZ = blockPos.method_10260() + 1;
        double delta = this.GRAVITY_EFFECT_HEIGHT - 1.0;
        switch (direction) {
            case field_11033: {
                maxY += delta;
                break;
            }
            case field_11036: {
                minY -= delta;
                break;
            }
            case field_11043: {
                maxZ += delta;
                break;
            }
            case field_11035: {
                minZ -= delta;
                break;
            }
            case field_11039: {
                maxX += delta;
                break;
            }
            case field_11034: {
                minX -= delta;
            }
        }
        return new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

