/*
 * Decompiled with CFR 0.152.
 */
package cyborgcabbage.amethystgravity.block.entity;

import com.fusionflux.gravity_api.util.RotationUtil;
import cyborgcabbage.amethystgravity.AmethystGravity;
import cyborgcabbage.amethystgravity.block.CylinderFieldGeneratorBlock;
import cyborgcabbage.amethystgravity.block.entity.AbstractFieldGeneratorBlockEntity;
import cyborgcabbage.amethystgravity.block.ui.CylinderFieldGeneratorScreenHandler;
import cyborgcabbage.amethystgravity.gravity.GravityEffect;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import org.jetbrains.annotations.Nullable;

public class CylinderFieldGeneratorBlockEntity
extends AbstractFieldGeneratorBlockEntity {
    private static final String RADIUS_KEY = "Radius";
    private static final String WIDTH_KEY = "Width";
    private int radius = 10;
    private int width = 10;

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public CylinderFieldGeneratorBlockEntity(class_2338 pos, class_2680 state) {
        super(AmethystGravity.CYLINDER_FIELD_GENERATOR_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void clientTick(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        class_2350.class_2351 a = (class_2350.class_2351)blockState.method_11654(CylinderFieldGeneratorBlock.AXIS);
        class_2350 direction = this.fromAxis(a);
        class_238 box = this.getGravityEffectBox();
        List<class_2350> dList = Arrays.stream(class_2350.values()).filter(d -> d.method_10166() != a).toList();
        GravityEffect.applyGravityEffectToPlayers(this.getGravityEffect(direction, blockPos), box, world, this.getPolarity() != 0, dList, false);
    }

    @Override
    protected void serverTick(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        class_2350.class_2351 a = (class_2350.class_2351)blockState.method_11654(CylinderFieldGeneratorBlock.AXIS);
        class_2350 direction = this.fromAxis(a);
        class_238 box = this.getGravityEffectBox();
        List<class_2350> dList = Arrays.stream(class_2350.values()).filter(d -> d.method_10166() != a).toList();
        GravityEffect.applyGravityEffectToEntities(this.getGravityEffect(direction, blockPos), box, world, this.getPolarity() != 0, dList, false);
        if (world.method_8409().method_43048(20) == 0) {
            int found = this.searchAmethyst();
            while (this.radius > 1 && this.calculateRequiredAmethyst() > found) {
                --this.radius;
            }
            while (this.width > 10 && this.calculateRequiredAmethyst() > found) {
                --this.width;
            }
            if (world instanceof class_3218) {
                class_3218 sw = (class_3218)world;
                sw.method_8524(this.field_11867);
                sw.method_14178().method_14128(this.field_11867);
            }
        }
    }

    private GravityEffect getGravityEffect(class_2350 direction, class_2338 blockPos) {
        return new GravityEffect(direction, CylinderFieldGeneratorBlockEntity.getVolume(this.getGravityEffectBox()), blockPos);
    }

    private class_2350 fromAxis(class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> class_2350.field_11039;
            case class_2350.class_2351.field_11052 -> class_2350.field_11033;
            case class_2350.class_2351.field_11051 -> class_2350.field_11043;
        };
    }

    @Override
    public class_238 getGravityEffectBox() {
        class_2350 direction = this.fromAxis((class_2350.class_2351)this.method_11010().method_11654(CylinderFieldGeneratorBlock.AXIS));
        double w = (double)this.width / 10.0 / 2.0;
        double r = (double)this.radius / 10.0 + 0.5;
        class_243 pos1 = RotationUtil.vecPlayerToWorld((double)(-r), (double)(-w), (double)(-r), (class_2350)direction);
        class_243 pos2 = RotationUtil.vecPlayerToWorld((double)r, (double)w, (double)r, (class_2350)direction);
        return new class_238(pos1, pos2).method_996(this.method_11016()).method_989(0.5, 0.5, 0.5);
    }

    public class_2350.class_2351 getAxis() {
        return (class_2350.class_2351)this.method_11010().method_11654(CylinderFieldGeneratorBlock.AXIS);
    }

    public double getRadius() {
        return (double)this.radius * 0.1;
    }

    public double getWidth() {
        return (double)this.width * 0.1;
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569(RADIUS_KEY, this.radius);
        nbt.method_10569(WIDTH_KEY, this.width);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.radius = nbt.method_10550(RADIUS_KEY);
        this.width = nbt.method_10550(WIDTH_KEY);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new CylinderFieldGeneratorScreenHandler(syncId, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.method_11016()));
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.writeInt(this.radius);
        packetByteBuf.writeInt(this.width);
        packetByteBuf.writeInt(this.polarity);
    }

    public void updateSettings(class_3222 player, int radius, int width, int polarity) {
        int oldRadius = this.radius;
        int oldWidth = this.width;
        int oldPolarity = this.polarity;
        this.setRadius(radius);
        this.setWidth(width);
        this.setPolarity(polarity);
        int required = this.calculateRequiredAmethyst();
        int found = this.searchAmethyst();
        if (required > found) {
            this.setRadius(oldRadius);
            this.setWidth(oldWidth);
            this.setPolarity(oldPolarity);
        }
        player.method_7353((class_2561)class_2561.method_43469((String)"amethystgravity.fieldGenerator.blocks", (Object[])new Object[]{required, found}).method_27692(required > found ? class_124.field_1061 : class_124.field_1060), true);
    }
}

