/*
 * Decompiled with CFR 0.152.
 */
package cyborgcabbage.amethystgravity.block.entity;

import com.fusionflux.gravity_api.util.RotationUtil;
import cyborgcabbage.amethystgravity.AmethystGravity;
import cyborgcabbage.amethystgravity.block.FieldGeneratorBlock;
import cyborgcabbage.amethystgravity.block.entity.AbstractFieldGeneratorBlockEntity;
import cyborgcabbage.amethystgravity.block.ui.FieldGeneratorScreenHandler;
import cyborgcabbage.amethystgravity.gravity.GravityEffect;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import org.jetbrains.annotations.Nullable;

public class FieldGeneratorBlockEntity
extends AbstractFieldGeneratorBlockEntity {
    private static final String HEIGHT_KEY = "Height";
    private static final String WIDTH_KEY = "Width";
    private static final String DEPTH_KEY = "Depth";
    private int height = 10;
    private int width = 10;
    private int depth = 10;

    public FieldGeneratorBlockEntity(class_2338 pos, class_2680 state) {
        super(AmethystGravity.FIELD_GENERATOR_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void clientTick(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        class_2350 direction = ((class_2350)blockState.method_11654((class_2769)FieldGeneratorBlock.FACING)).method_10153();
        class_238 box = this.getGravityEffectBox();
        GravityEffect.applyGravityEffectToPlayers(this.getGravityEffect(direction, blockPos), box, world, this.getPolarity() != 0, List.of(direction), false);
    }

    @Override
    protected void serverTick(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        class_2350 direction = ((class_2350)blockState.method_11654((class_2769)FieldGeneratorBlock.FACING)).method_10153();
        class_238 box = this.getGravityEffectBox();
        GravityEffect.applyGravityEffectToEntities(this.getGravityEffect(direction, blockPos), box, world, this.getPolarity() != 0, List.of(direction), false);
        if (world.method_8409().method_43048(20) == 0) {
            int found = this.searchAmethyst();
            while (this.height > 1 && this.calculateRequiredAmethyst() > found) {
                --this.height;
            }
            while (this.width > 10 && this.calculateRequiredAmethyst() > found) {
                --this.width;
            }
            while (this.depth > 10 && this.calculateRequiredAmethyst() > found) {
                --this.depth;
            }
            if (world instanceof class_3218) {
                class_3218 sw = (class_3218)world;
                sw.method_8524(this.field_11867);
                sw.method_14178().method_14128(this.field_11867);
            }
        }
    }

    @Override
    public class_238 getGravityEffectBox() {
        class_2338 blockPos = this.method_11016();
        class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)FieldGeneratorBlock.FACING)).method_10153();
        class_243 blockCentre = new class_243((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260()).method_1031(0.5, 0.5, 0.5);
        class_243 faceCentre = blockCentre.method_1019(new class_243(direction.method_23955()).method_1021(-0.5));
        class_243 pos1 = RotationUtil.vecPlayerToWorld((double)(-0.5 * (double)this.width * 0.1), (double)0.0, (double)(-0.5 * (double)this.depth * 0.1), (class_2350)direction);
        class_243 pos2 = RotationUtil.vecPlayerToWorld((double)(0.5 * (double)this.width * 0.1), (double)((double)this.height * 0.1), (double)(0.5 * (double)this.depth * 0.1), (class_2350)direction);
        return new class_238(pos1, pos2).method_997(faceCentre);
    }

    private GravityEffect getGravityEffect(class_2350 direction, class_2338 blockPos) {
        return new GravityEffect(direction, FieldGeneratorBlockEntity.getVolume(this.getGravityEffectBox()), blockPos);
    }

    public class_2350 getDirection() {
        return ((class_2350)this.method_11010().method_11654((class_2769)FieldGeneratorBlock.FACING)).method_10153();
    }

    public double getHeight() {
        return (double)this.height * 0.1;
    }

    public double getWidth() {
        return (double)this.width * 0.1;
    }

    public double getDepth() {
        return (double)this.depth * 0.1;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569(HEIGHT_KEY, this.height);
        nbt.method_10569(WIDTH_KEY, this.width);
        nbt.method_10569(DEPTH_KEY, this.depth);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.height = nbt.method_10550(HEIGHT_KEY);
        this.width = nbt.method_10550(WIDTH_KEY);
        this.depth = nbt.method_10550(DEPTH_KEY);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new FieldGeneratorScreenHandler(syncId, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.method_11016()));
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.writeInt(this.height);
        buf.writeInt(this.width);
        buf.writeInt(this.depth);
        buf.writeInt(this.polarity);
    }

    public void updateSettings(class_3222 player, int height, int width, int depth, int polarity) {
        int oldHeight = this.height;
        int oldWidth = this.width;
        int oldDepth = this.depth;
        int oldPolarity = this.polarity;
        this.setHeight(height);
        this.setWidth(width);
        this.setDepth(depth);
        this.setPolarity(polarity);
        int required = this.calculateRequiredAmethyst();
        int found = this.searchAmethyst();
        if (required > found) {
            this.setHeight(oldHeight);
            this.setWidth(oldWidth);
            this.setDepth(oldDepth);
            this.setPolarity(oldPolarity);
        }
        player.method_7353((class_2561)class_2561.method_43469((String)"amethystgravity.fieldGenerator.blocks", (Object[])new Object[]{required, found}).method_27692(required > found ? class_124.field_1061 : class_124.field_1060), true);
    }
}

