/*
 * Decompiled with CFR 0.152.
 */
package cyborgcabbage.amethystgravity.block.entity;

import cyborgcabbage.amethystgravity.AmethystGravity;
import cyborgcabbage.amethystgravity.block.entity.AbstractFieldGeneratorBlockEntity;
import cyborgcabbage.amethystgravity.block.ui.PlanetFieldGeneratorScreenHandler;
import cyborgcabbage.amethystgravity.gravity.GravityEffect;
import java.util.Arrays;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import org.jetbrains.annotations.Nullable;

public class PlanetFieldGeneratorBlockEntity
extends AbstractFieldGeneratorBlockEntity {
    private static final String RADIUS_KEY = "Radius";
    private int radius = 10;

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public PlanetFieldGeneratorBlockEntity(class_2338 pos, class_2680 state) {
        super(AmethystGravity.PLANET_FIELD_GENERATOR_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void clientTick(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        class_238 box = this.getGravityEffectBox();
        GravityEffect.applyGravityEffectToPlayers(this.getGravityEffect(blockPos), box, world, this.getPolarity() != 0, Arrays.asList(class_2350.values()), false);
    }

    @Override
    protected void serverTick(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        class_238 box = this.getGravityEffectBox();
        GravityEffect.applyGravityEffectToEntities(this.getGravityEffect(blockPos), box, world, this.getPolarity() != 0, Arrays.asList(class_2350.values()), false);
        if (world.method_8409().method_43048(20) == 0) {
            int found = this.searchAmethyst();
            while (this.radius > 1 && this.calculateRequiredAmethyst() > found) {
                --this.radius;
            }
            if (world instanceof class_3218) {
                class_3218 sw = (class_3218)world;
                sw.method_8524(this.field_11867);
                sw.method_14178().method_14128(this.field_11867);
            }
        }
    }

    @Override
    public class_238 getGravityEffectBox() {
        class_2338 blockPos = this.method_11016();
        class_243 pos1 = new class_243((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
        class_243 pos2 = pos1.method_1031(1.0, 1.0, 1.0);
        return new class_238(pos1, pos2).method_1014(this.getRadius());
    }

    private GravityEffect getGravityEffect(class_2338 blockPos) {
        return new GravityEffect(null, this.getVolume(), blockPos);
    }

    public double getRadius() {
        return (double)this.radius / 10.0;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new PlanetFieldGeneratorScreenHandler(syncId, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.method_11016()));
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569(RADIUS_KEY, this.radius);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.radius = nbt.method_10550(RADIUS_KEY);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.writeInt(this.radius);
        buf.writeInt(this.polarity);
    }

    public void updateSettings(class_3222 player, int radius, int polarity) {
        int oldRadius = this.radius;
        int oldPolarity = this.polarity;
        this.setRadius(radius);
        this.setPolarity(polarity);
        int required = this.calculateRequiredAmethyst();
        int found = this.searchAmethyst();
        if (required > found) {
            this.setRadius(oldRadius);
            this.setPolarity(oldPolarity);
        }
        player.method_7353((class_2561)class_2561.method_43469((String)"amethystgravity.fieldGenerator.blocks", (Object[])new Object[]{required, found}).method_27692(required > found ? class_124.field_1061 : class_124.field_1060), true);
    }
}

