/*
 * Decompiled with CFR 0.152.
 */
package cyborgcabbage.amethystgravity.block.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import cyborgcabbage.amethystgravity.AmethystGravity;
import cyborgcabbage.amethystgravity.block.ui.AbstractFieldGeneratorScreenHandler;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_757;

public abstract class AbstractFieldGeneratorScreen<T extends AbstractFieldGeneratorScreenHandler>
extends class_465<T> {
    private static final class_2960 TEXTURE = new class_2960("amethystgravity", "textures/gui/blank.png");
    protected final T sh;
    class_4185 polarityButton;
    class_4185 applyChanges;

    public AbstractFieldGeneratorScreen(T handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.field_25270 = -100;
        this.sh = handler;
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.method_25302(matrices, x, y, 0, 0, this.field_2792, this.field_2779);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.renderValuesAndLabels(matrices);
        this.method_2380(matrices, mouseX, mouseY);
        if (this.polarityButton != null) {
            this.polarityButton.method_25355(this.getPolarityText());
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.field_25267 = (this.field_2792 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
        int bWidth = 120;
        int bHeight = 20;
        int bX = (this.field_22789 - bWidth) / 2;
        int bY = (this.field_22790 - bHeight) / 2 + 5;
        this.polarityButton = (class_4185)this.method_37063((class_364)new class_4185(bX, bY + 30, bWidth, bHeight, this.getPolarityText(), button -> {
            ((AbstractFieldGeneratorScreenHandler)((Object)((Object)this.sh))).polarity = 1 - ((AbstractFieldGeneratorScreenHandler)((Object)((Object)this.sh))).polarity;
        }));
        this.applyChanges = (class_4185)this.method_37063((class_364)new class_4185(bX, bY + 55, bWidth, bHeight, (class_2561)class_2561.method_43471((String)"amethystgravity.fieldGenerator.applyChanges"), button -> {
            this.sendMenuUpdatePacket(((AbstractFieldGeneratorScreenHandler)((Object)((Object)this.sh))).height, ((AbstractFieldGeneratorScreenHandler)((Object)((Object)this.sh))).width, ((AbstractFieldGeneratorScreenHandler)((Object)((Object)this.sh))).depth, ((AbstractFieldGeneratorScreenHandler)((Object)((Object)this.sh))).radius, ((AbstractFieldGeneratorScreenHandler)((Object)((Object)this.sh))).polarity);
            this.method_25419();
        }));
    }

    private class_2561 getPolarityText() {
        if (((AbstractFieldGeneratorScreenHandler)((Object)this.sh)).polarity == 0) {
            return class_2561.method_43471((String)"amethystgravity.fieldGenerator.attract");
        }
        return class_2561.method_43471((String)"amethystgravity.fieldGenerator.repel");
    }

    protected abstract void renderValuesAndLabels(class_4587 var1);

    protected void drawValue(class_4587 matrices, double value, int xOffset) {
        int tX = this.field_22789 / 2;
        Objects.requireNonNull(this.field_22793);
        int tY = (this.field_22790 - 9) / 2 + 6;
        DecimalFormat df = new DecimalFormat("0.0");
        String heightValue = df.format(value);
        this.field_22793.method_1729(matrices, heightValue, (float)tX - (float)this.field_22793.method_1727(heightValue) / 2.0f + (float)xOffset, (float)(tY - 20), Color.DARK_GRAY.getRGB());
    }

    protected void drawLabel(class_4587 matrices, String label, int xOffset) {
        int tX = this.field_22789 / 2;
        Objects.requireNonNull(this.field_22793);
        int tY = (this.field_22790 - 9) / 2 + 6;
        this.field_22793.method_1729(matrices, label, (float)tX - (float)this.field_22793.method_1727(label) / 2.0f + 0.5f + (float)xOffset, (float)(tY - 60), Color.DARK_GRAY.getRGB());
    }

    protected void sendMenuUpdatePacket(int height, int width, int depth, int radius, int polarity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(height);
        buf.writeInt(width);
        buf.writeInt(depth);
        buf.writeInt(radius);
        buf.writeInt(polarity);
        ClientPlayNetworking.send((class_2960)AmethystGravity.FIELD_GENERATOR_MENU_CHANNEL, (class_2540)buf);
    }
}

