/*
 * Decompiled with CFR 0.152.
 */
package cyborgcabbage.amethystgravity.gravity;

import com.fusionflux.gravity_api.api.RotationParameters;
import com.fusionflux.gravity_api.util.Gravity;
import com.fusionflux.gravity_api.util.packet.UpdateGravityPacket;
import cyborgcabbage.amethystgravity.block.PlatingBlock;
import cyborgcabbage.amethystgravity.block.entity.AbstractFieldGeneratorBlockEntity;
import cyborgcabbage.amethystgravity.gravity.GravityEffect;
import java.util.ArrayList;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class FieldGravityVerifier {
    public static class_2960 FIELD_GRAVITY_SOURCE = new class_2960("amethystgravity", "field");
    public static int FIELD_GRAVITY_PRIORITY = 100;
    public static int FIELD_GRAVITY_MAX_DURATION = 100;

    public static Gravity newFieldGravity(class_2350 direction, RotationParameters rp) {
        return new Gravity(direction, FIELD_GRAVITY_PRIORITY, FIELD_GRAVITY_MAX_DURATION, FIELD_GRAVITY_SOURCE.toString(), rp);
    }

    public static boolean check(class_3222 player, class_2540 info, UpdateGravityPacket packet) {
        if (packet.gravity.duration() > FIELD_GRAVITY_MAX_DURATION) {
            return false;
        }
        if (packet.gravity.priority() > FIELD_GRAVITY_PRIORITY) {
            return false;
        }
        if (!packet.gravity.source().equals(FIELD_GRAVITY_SOURCE.toString())) {
            return false;
        }
        if (packet.gravity.direction() == null) {
            return true;
        }
        class_2338 blockPos = info.method_10811();
        class_3218 world = player.method_14220();
        if (world == null) {
            return false;
        }
        class_2586 blockEntity = world.method_8321(blockPos);
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_26204() instanceof PlatingBlock) {
            ArrayList<class_2350> directions = PlatingBlock.getDirections(blockState);
            if (directions.contains(packet.gravity.direction())) {
                double distance = GravityEffect.getGravityOrigin((class_1297)player).method_1022(new class_243((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5));
                return distance < 5.0;
            }
        } else if (blockEntity instanceof AbstractFieldGeneratorBlockEntity) {
            AbstractFieldGeneratorBlockEntity fieldBlockEntity = (AbstractFieldGeneratorBlockEntity)blockEntity;
            class_238 gravityEffectBox = fieldBlockEntity.getGravityEffectBox();
            return gravityEffectBox.method_1014(3.0).method_994(GravityEffect.getGravityEffectCollider((class_1297)player));
        }
        return false;
    }

    public static class_2540 packInfo(class_2338 block) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(block);
        return buf;
    }
}

