/*
 * Decompiled with CFR 0.152.
 */
package cyborgcabbage.amethystgravity.gravity;

import com.fusionflux.gravity_api.api.GravityChangerAPI;
import com.fusionflux.gravity_api.util.RotationUtil;
import cyborgcabbage.amethystgravity.gravity.GravityData;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4048;
import net.minecraft.class_746;

public record GravityEffect(class_2350 direction, double volume, class_2338 source) {
    public static class_238 getGravityEffectCollider(class_1297 entity) {
        class_4048 d = entity.method_18377(entity.method_18376());
        double hw = (double)d.field_18067 / 2.0;
        class_243 pos1 = RotationUtil.vecPlayerToWorld((double)hw, (double)(2.0 * hw), (double)hw, (class_2350)GravityChangerAPI.getGravityDirection((class_1297)entity));
        class_243 pos2 = RotationUtil.vecPlayerToWorld((double)(-hw), (double)0.0, (double)(-hw), (class_2350)GravityChangerAPI.getGravityDirection((class_1297)entity));
        return new class_238(pos1, pos2).method_997(entity.method_19538());
    }

    public static class_238 getLowerGravityEffectCollider(class_1297 entity) {
        class_4048 d = entity.method_18377(entity.method_18376());
        double hw = (double)d.field_18067 / 2.0;
        class_243 pos1 = RotationUtil.vecPlayerToWorld((double)hw, (double)-0.1, (double)hw, (class_2350)GravityChangerAPI.getGravityDirection((class_1297)entity));
        class_243 pos2 = RotationUtil.vecPlayerToWorld((double)(-hw), (double)0.0, (double)(-hw), (class_2350)GravityChangerAPI.getGravityDirection((class_1297)entity));
        return new class_238(pos1, pos2).method_997(entity.method_19538());
    }

    @Environment(value=EnvType.CLIENT)
    public static void applyGravityEffectToPlayers(GravityEffect gravityEffect, class_238 box, class_1937 world, boolean opposite, List<class_2350> directions, boolean lower) {
        List playerEntities = world.method_8390(class_746.class, box.method_1014(0.5), e -> true);
        for (class_746 player : playerEntities) {
            class_243 boxCentre = box.method_1005();
            class_243 playerCentre = GravityEffect.getGravityOrigin((class_1297)player);
            Optional<class_2350> optionalEffectiveDirection = directions.stream().max(Comparator.comparingDouble(d -> boxCentre.method_1019(new class_243(d.method_23955())).method_1022(playerCentre)));
            if (optionalEffectiveDirection.isEmpty()) {
                return;
            }
            class_2350 effectiveDirection = optionalEffectiveDirection.get();
            if (opposite) {
                effectiveDirection = effectiveDirection.method_10153();
            }
            class_238 gravityEffectCollider = (gravityEffect = new GravityEffect(effectiveDirection, gravityEffect.volume(), gravityEffect.source())).direction().method_10153() == GravityChangerAPI.getGravityDirection((class_1297)player) ? player.method_5829() : GravityEffect.getGravityEffectCollider((class_1297)player);
            class_238 lowerGravityEffectCollider = GravityEffect.getLowerGravityEffectCollider((class_1297)player);
            if (box.method_994(gravityEffectCollider)) {
                ((GravityData)player).getFieldList().add(gravityEffect);
            }
            if (!lower || !box.method_994(lowerGravityEffectCollider)) continue;
            ((GravityData)player).getLowerFieldList().add(gravityEffect);
        }
    }

    public static void applyGravityEffectToEntities(GravityEffect gravityEffect, class_238 box, class_1937 world, boolean opposite, List<class_2350> directions, boolean lower) {
        List entities = world.method_8390(class_1297.class, box.method_1014(0.5), e -> true);
        for (class_1297 entity : entities) {
            class_243 boxCentre = box.method_1005();
            class_243 entityCentre = GravityEffect.getGravityOrigin(entity);
            Optional<class_2350> optionalEffectiveDirection = directions.stream().max(Comparator.comparingDouble(d -> boxCentre.method_1019(new class_243(d.method_23955())).method_1022(entityCentre)));
            if (optionalEffectiveDirection.isEmpty()) {
                return;
            }
            class_2350 effectiveDirection = optionalEffectiveDirection.get();
            if (opposite) {
                effectiveDirection = effectiveDirection.method_10153();
            }
            class_238 gravityEffectCollider = (gravityEffect = new GravityEffect(effectiveDirection, gravityEffect.volume(), gravityEffect.source())).direction().method_10153() == GravityChangerAPI.getGravityDirection((class_1297)entity) ? entity.method_5829() : GravityEffect.getGravityEffectCollider(entity);
            class_238 lowerGravityEffectCollider = GravityEffect.getLowerGravityEffectCollider(entity);
            if (box.method_994(gravityEffectCollider)) {
                ((GravityData)entity).getFieldList().add(gravityEffect);
            }
            if (!lower || !box.method_994(lowerGravityEffectCollider)) continue;
            ((GravityData)entity).getLowerFieldList().add(gravityEffect);
        }
    }

    public static class_243 getGravityOrigin(class_1297 entity) {
        class_4048 dim = entity.method_18377(entity.method_18376());
        return entity.method_19538().method_1019(RotationUtil.vecPlayerToWorld((double)0.0, (double)((double)dim.field_18067 / 2.0), (double)0.0, (class_2350)GravityChangerAPI.getGravityDirection((class_1297)entity)));
    }
}

