/*
 * Decompiled with CFR 0.152.
 */
package cyborgcabbage.amethystgravity.mixin;

import com.fusionflux.gravity_api.api.GravityChangerAPI;
import com.fusionflux.gravity_api.api.RotationParameters;
import com.fusionflux.gravity_api.util.Gravity;
import com.fusionflux.gravity_api.util.RotationUtil;
import cyborgcabbage.amethystgravity.gravity.FieldGravityVerifier;
import cyborgcabbage.amethystgravity.gravity.GravityData;
import cyborgcabbage.amethystgravity.gravity.GravityEffect;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1297.class}, priority=999)
public abstract class EntityMixinClient
implements GravityData {
    public ArrayList<GravityEffect> amethystgravity$gravityEffectList = new ArrayList();
    public ArrayList<GravityEffect> amethystgravity$lowerGravityEffectList = new ArrayList();
    public GravityEffect amethystgravity$gravityEffect = null;
    public int amethystgravity$counter = 0;

    @Override
    public ArrayList<GravityEffect> getFieldList() {
        return this.amethystgravity$gravityEffectList;
    }

    @Override
    public ArrayList<GravityEffect> getLowerFieldList() {
        return this.amethystgravity$lowerGravityEffectList;
    }

    @Override
    public void setFieldGravity(GravityEffect _gravityEffect) {
        this.amethystgravity$gravityEffect = _gravityEffect;
    }

    @Override
    public GravityEffect getFieldGravity() {
        return this.amethystgravity$gravityEffect;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickInject(CallbackInfo ci) {
        class_1297 entity = (class_1297)this;
        if (!(entity instanceof class_1309) && !entity.field_6002.field_9236) {
            class_2350 newDirection;
            GravityEffect currentGravity = this.getFieldGravity();
            GravityEffect newGravity = null;
            ArrayList<GravityEffect> directions = this.getFieldList();
            ++this.amethystgravity$counter;
            if (this.amethystgravity$counter >= 5) {
                this.amethystgravity$counter = 0;
            }
            if (!entity.method_7325()) {
                double lowestVolume = directions.stream().map(GravityEffect::volume).min(Double::compare).orElse(0.0);
                List<GravityEffect> highestPriority = directions.stream().filter(g -> g.volume() == lowestVolume).toList();
                if (highestPriority.size() > 0) {
                    newGravity = highestPriority.get(0);
                }
                if (currentGravity != null && highestPriority.size() > 0) {
                    newGravity = highestPriority.stream().filter(ge -> ge.direction() == currentGravity.direction()).findFirst().orElse(newGravity);
                }
            }
            class_2350 oldDirection = currentGravity == null ? null : currentGravity.direction();
            class_2350 class_23502 = newDirection = newGravity == null ? null : newGravity.direction();
            if (oldDirection != newDirection || this.amethystgravity$counter == 0) {
                GravityChangerAPI.addGravity((class_1297)entity, (Gravity)FieldGravityVerifier.newFieldGravity(newDirection, new RotationParameters()));
            }
            this.setFieldGravity(newGravity);
            this.getFieldList().clear();
            this.getLowerFieldList().clear();
        }
    }

    @ModifyVariable(method={"move"}, at=@At(value="HEAD"), argsOnly=true)
    private class_243 moveInject(class_243 movement) {
        class_1297 e = (class_1297)this;
        if (movement == e.method_18798() && e instanceof class_1309) {
            class_1309 entity = (class_1309)e;
            if (entity instanceof class_746 || !(entity instanceof class_1657) && !entity.field_6002.field_9236) {
                class_2350 newDirection;
                boolean isFlying = false;
                if (entity instanceof class_1657) {
                    class_1657 pe = (class_1657)entity;
                    isFlying = pe.method_31549().field_7479;
                }
                boolean isFallFlying = entity.method_6128();
                GravityEffect currentGravity = this.getFieldGravity();
                GravityEffect newGravity = null;
                ArrayList<GravityEffect> directions = this.getFieldList();
                ++this.amethystgravity$counter;
                if (this.amethystgravity$counter >= 5) {
                    this.amethystgravity$counter = 0;
                }
                if (!entity.method_7325() && !isFlying) {
                    class_243 adjustedMovement;
                    double lowestVolume = directions.stream().map(GravityEffect::volume).min(Double::compare).orElse(0.0);
                    List<GravityEffect> highestPriority = directions.stream().filter(g -> g.volume() == lowestVolume).toList();
                    if (highestPriority.size() > 0) {
                        newGravity = highestPriority.get(0);
                    }
                    ArrayList<class_2350> localCollidingDirections = new ArrayList<class_2350>();
                    class_238 box = entity.method_5829();
                    List entityCollisions = entity.field_6002.method_20743((class_1297)entity, box.method_18804(movement));
                    class_243 class_2432 = adjustedMovement = movement.method_1027() == 0.0 ? movement : class_1297.method_20736((class_1297)entity, (class_243)movement, (class_238)box, (class_1937)entity.field_6002, (List)entityCollisions);
                    if (movement.field_1352 > adjustedMovement.field_1352) {
                        localCollidingDirections.add(class_2350.field_11034);
                    }
                    if (movement.field_1352 < adjustedMovement.field_1352) {
                        localCollidingDirections.add(class_2350.field_11039);
                    }
                    if (movement.field_1351 > adjustedMovement.field_1351) {
                        localCollidingDirections.add(class_2350.field_11036);
                    }
                    if (movement.field_1351 < adjustedMovement.field_1351) {
                        localCollidingDirections.add(class_2350.field_11033);
                    }
                    if (movement.field_1350 > adjustedMovement.field_1350) {
                        localCollidingDirections.add(class_2350.field_11035);
                    }
                    if (movement.field_1350 < adjustedMovement.field_1350) {
                        localCollidingDirections.add(class_2350.field_11043);
                    }
                    if (currentGravity != null && highestPriority.size() > 0) {
                        newGravity = highestPriority.stream().filter(ge -> ge.direction() == currentGravity.direction()).findFirst().orElse(newGravity);
                    }
                    if (currentGravity != null && localCollidingDirections.contains(class_2350.field_11033)) {
                        newGravity = this.getInsideCornerSnapDirection(currentGravity, highestPriority, localCollidingDirections).orElse(newGravity);
                    }
                    if (currentGravity != null && !localCollidingDirections.contains(class_2350.field_11033)) {
                        newGravity = this.getOutsideCornerSnapDirection(currentGravity, newGravity, movement).orElse(newGravity);
                    }
                }
                class_2350 oldDirection = currentGravity == null ? null : currentGravity.direction();
                class_2350 class_23502 = newDirection = newGravity == null ? null : newGravity.direction();
                if (oldDirection != newDirection || this.amethystgravity$counter == 0) {
                    class_2540 info = newGravity == null ? PacketByteBufs.create() : FieldGravityVerifier.packInfo(newGravity.source());
                    RotationParameters rotationParameters = new RotationParameters().alternateCenter(true).rotateView(!isFallFlying).rotateVelocity(entity.method_24828());
                    if (entity instanceof class_746) {
                        class_746 cpe = (class_746)entity;
                        GravityChangerAPI.addGravityClient((class_746)cpe, (Gravity)FieldGravityVerifier.newFieldGravity(newDirection, rotationParameters), (class_2960)FieldGravityVerifier.FIELD_GRAVITY_SOURCE, (class_2540)info);
                    } else {
                        GravityChangerAPI.addGravity((class_1297)entity, (Gravity)FieldGravityVerifier.newFieldGravity(newDirection, rotationParameters));
                    }
                }
                this.setFieldGravity(newGravity);
            }
            this.getFieldList().clear();
            this.getLowerFieldList().clear();
            return entity.method_18798();
        }
        return movement;
    }

    private Optional<GravityEffect> getInsideCornerSnapDirection(GravityEffect currentGravity, List<GravityEffect> effects, List<class_2350> localCollidingDirections) {
        for (class_2350 localDirection : localCollidingDirections) {
            if (localDirection == class_2350.field_11036 || localDirection == class_2350.field_11033) continue;
            class_2350 globalDirection = RotationUtil.dirPlayerToWorld((class_2350)localDirection, (class_2350)currentGravity.direction());
            Optional<GravityEffect> effect = effects.stream().filter(ge -> ge.direction() == globalDirection).findFirst();
            if (!effect.isPresent()) continue;
            return effect;
        }
        return Optional.empty();
    }

    private Optional<GravityEffect> getOutsideCornerSnapDirection(GravityEffect currentGravity, @Nullable GravityEffect newGravity, class_243 movement) {
        ArrayList<GravityEffect> effectsBelowPlayer;
        Optional<GravityEffect> min;
        if ((newGravity == null || currentGravity.volume() < newGravity.volume() / 4.0) && (min = (effectsBelowPlayer = this.getLowerFieldList()).stream().min(Comparator.comparingDouble(GravityEffect::volume))).isPresent()) {
            double minVolume = min.get().volume();
            effectsBelowPlayer.removeIf(ge -> ge.volume() > minVolume);
            class_243 velocity = RotationUtil.vecPlayerToWorld((class_243)movement, (class_2350)currentGravity.direction());
            List<class_2350> hDir = this.getHorizontalDirections();
            hDir.sort((d1, d2) -> {
                double dot1 = velocity.method_1026(new class_243(d1.method_23955()));
                double dot2 = velocity.method_1026(new class_243(d2.method_23955()));
                return Double.compare(dot1, dot2);
            });
            for (class_2350 d : hDir) {
                Optional<GravityEffect> effect = effectsBelowPlayer.stream().filter(g -> g.direction() == d).findFirst();
                if (!effect.isPresent()) continue;
                return effect;
            }
        }
        return Optional.empty();
    }

    private static boolean arePerpendicular(class_2350 dir0, class_2350 dir1) {
        return dir0 != dir1 && dir0 != dir1.method_10153();
    }

    private List<class_2350> getHorizontalDirections() {
        ArrayList<class_2350> directions = new ArrayList<class_2350>();
        directions.add(class_2350.field_11043);
        directions.add(class_2350.field_11035);
        directions.add(class_2350.field_11034);
        directions.add(class_2350.field_11039);
        class_2350 gravityDirection = this.getFieldGravity().direction();
        directions.replaceAll(direction -> RotationUtil.dirPlayerToWorld((class_2350)direction, (class_2350)gravityDirection));
        return directions;
    }
}

