/*
 * Decompiled with CFR 0.152.
 */
package com.thaddev.iw2thshortbows.content.entities.projectiles;

import com.google.common.collect.Sets;
import com.thaddev.iw2thshortbows.mechanics.inits.EntityTypeInit;
import com.thaddev.iw2thshortbows.mechanics.inits.ItemInit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1527;
import net.minecraft.class_1528;
import net.minecraft.class_1560;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3966;

public class DiamondHeadedArrow
extends class_1665 {
    private static final int MAX_POTION_DURATION_TICKS = 600;
    private static final int NO_POTION_COLOR = -1;
    private static final class_2940<Integer> COLOR = class_2945.method_12791(DiamondHeadedArrow.class, (class_2941)class_2943.field_13327);
    private static final byte PARTICLE_EFFECT_STATUS = 0;
    private class_1842 potion = class_1847.field_8984;
    private final Set<class_1293> effects = Sets.newHashSet();
    private boolean colorSet;
    private boolean shotByShortbow;
    private boolean isHoming;
    private boolean hasHitTarget;
    class_1309 target;

    public DiamondHeadedArrow(class_1299<? extends DiamondHeadedArrow> entityType, class_1937 world) {
        super(entityType, world);
        this.method_7438(4.0);
        this.method_7451((byte)5);
    }

    public DiamondHeadedArrow(class_1937 world, class_1309 owner) {
        super(EntityTypeInit.DIAMOND_HEADED_ARROW, owner, world);
        this.method_7438(4.0);
        this.method_7451((byte)5);
    }

    public void initFromStack(class_1799 stack) {
        if (stack.method_31574(ItemInit.TIPPED_DIAMOND_HEADED_ARROW)) {
            int i;
            this.potion = class_1844.method_8063((class_1799)stack);
            List collection = class_1844.method_8068((class_1799)stack);
            if (!collection.isEmpty()) {
                for (class_1293 statusEffectInstance : collection) {
                    this.effects.add(new class_1293(statusEffectInstance));
                }
            }
            if ((i = DiamondHeadedArrow.getCustomPotionColor(stack)) == -1) {
                this.initColor();
            } else {
                this.setColor(i);
            }
        } else if (stack.method_31574(ItemInit.DIAMOND_HEADED_ARROW)) {
            this.potion = class_1847.field_8984;
            this.effects.clear();
            this.field_6011.method_12778(COLOR, (Object)-1);
        }
    }

    public class_1799 method_7445() {
        if (this.effects.isEmpty() && this.potion == class_1847.field_8984) {
            return new class_1799((class_1935)ItemInit.DIAMOND_HEADED_ARROW);
        }
        class_1799 itemStack = new class_1799((class_1935)ItemInit.TIPPED_DIAMOND_HEADED_ARROW);
        class_1844.method_8061((class_1799)itemStack, (class_1842)this.potion);
        class_1844.method_8056((class_1799)itemStack, this.effects);
        if (this.colorSet) {
            itemStack.method_7948().method_10569("CustomPotionColor", this.getColor());
        }
        return itemStack;
    }

    public boolean getShotByShortbow() {
        return this.shotByShortbow;
    }

    public void setShotByShortbow(boolean shotByShortbow) {
        this.shotByShortbow = shotByShortbow;
    }

    public boolean isHoming() {
        return this.isHoming;
    }

    public void setHoming(boolean homing) {
        this.isHoming = homing;
    }

    public static int getCustomPotionColor(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7969();
        if (nbtCompound != null && nbtCompound.method_10573("CustomPotionColor", 99)) {
            return nbtCompound.method_10550("CustomPotionColor");
        }
        return -1;
    }

    private void initColor() {
        this.colorSet = false;
        if (this.potion == class_1847.field_8984 && this.effects.isEmpty()) {
            this.field_6011.method_12778(COLOR, (Object)-1);
        } else {
            this.field_6011.method_12778(COLOR, (Object)class_1844.method_8055((Collection)class_1844.method_8059((class_1842)this.potion, this.effects)));
        }
    }

    public void addEffect(class_1293 effect) {
        this.effects.add(effect);
        this.method_5841().method_12778(COLOR, (Object)class_1844.method_8055((Collection)class_1844.method_8059((class_1842)this.potion, this.effects)));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COLOR, (Object)-1);
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_7576 > 20 && this.shotByShortbow && this.field_7572 == class_1665.class_1666.field_7594) {
            this.method_31472();
        }
        if (!(!this.isHoming() || this.field_7588 && this.field_7576 > 10 || this.hasHitTarget)) {
            this.setTarget();
            if (this.target != null && this.target.method_5805()) {
                double d;
                float i = 5.0f;
                class_1309 class_13092 = this.target;
                if (class_13092 instanceof class_1510) {
                    class_1510 dragon = (class_1510)class_13092;
                    d = dragon.method_5690()[1].method_23318() - this.method_23318();
                } else {
                    d = this.target.method_23320() - this.method_23318();
                }
                double diffY = d;
                class_243 vec3d = new class_243(this.target.method_23317() - this.method_23317(), diffY, this.target.method_23321() - this.method_23321());
                this.method_23327(this.method_23317(), this.method_23318() + vec3d.field_1351 * 0.015 * (double)i, this.method_23321());
                if (this.field_6002.field_9236) {
                    this.field_5971 = this.method_23318();
                }
                double d2 = 0.1 * (double)i;
                this.method_18799(this.method_18798().method_18805(0.75, 0.75, 0.75).method_1019(vec3d.method_1029().method_18805(d2, d2, d2)));
            }
        }
        if (this.field_6002.field_9236) {
            if (this.field_7588) {
                if (this.field_7576 % 5 == 0) {
                    this.spawnParticles(1);
                }
            } else {
                this.spawnParticles(2);
            }
        } else if (this.field_7588 && this.field_7576 != 0 && !this.effects.isEmpty() && this.field_7576 >= 600) {
            this.field_6002.method_8421((class_1297)this, (byte)0);
            this.potion = class_1847.field_8984;
            this.effects.clear();
            this.field_6011.method_12778(COLOR, (Object)-1);
        }
    }

    private void spawnParticles(int amount) {
        int i = this.getColor();
        if (i == -1 || amount <= 0) {
            return;
        }
        double d = (double)(i >> 16 & 0xFF) / 255.0;
        double e = (double)(i >> 8 & 0xFF) / 255.0;
        double f = (double)(i >> 0 & 0xFF) / 255.0;
        for (int j = 0; j < amount; ++j) {
            this.field_6002.method_8406((class_2394)class_2398.field_11226, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), d, e, f);
        }
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(COLOR);
    }

    private void setColor(int color) {
        this.colorSet = true;
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.potion != class_1847.field_8984) {
            nbt.method_10582("Potion", class_2378.field_11143.method_10221((Object)this.potion).toString());
        }
        if (this.colorSet) {
            nbt.method_10569("Color", this.getColor());
        }
        if (this.shotByShortbow) {
            nbt.method_10556("ShotByShortbow", this.getShotByShortbow());
        }
        if (this.isHoming) {
            nbt.method_10556("IsHoming", this.isHoming());
        }
        if (!this.effects.isEmpty()) {
            class_2499 nbtList = new class_2499();
            for (class_1293 statusEffectInstance : this.effects) {
                nbtList.add((Object)statusEffectInstance.method_5582(new class_2487()));
            }
            nbt.method_10566("CustomPotionEffects", (class_2520)nbtList);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("Potion", 8)) {
            this.potion = class_1844.method_8057((class_2487)nbt);
        }
        for (class_1293 statusEffectInstance : class_1844.method_8060((class_2487)nbt)) {
            this.addEffect(statusEffectInstance);
        }
        if (nbt.method_10573("Color", 99)) {
            this.setColor(nbt.method_10550("Color"));
        } else {
            this.initColor();
        }
        if (nbt.method_10573("IsHoming", 99)) {
            this.setHoming(nbt.method_10577("IsHoming"));
        } else {
            this.setHoming(false);
        }
        if (nbt.method_10573("ShotByShortbow", 99)) {
            this.setShotByShortbow(nbt.method_10577("ShotByShortbow"));
        } else {
            this.setShotByShortbow(false);
        }
    }

    protected void method_7450(class_1309 target) {
        super.method_7450(target);
        class_1297 entity = this.method_37225();
        for (class_1293 statusEffectInstance : this.potion.method_8049()) {
            target.method_37222(new class_1293(statusEffectInstance.method_5579(), Math.max(statusEffectInstance.method_5584() / 8, 1), statusEffectInstance.method_5578(), statusEffectInstance.method_5591(), statusEffectInstance.method_5581()), entity);
        }
        if (!this.effects.isEmpty()) {
            for (class_1293 statusEffectInstance : this.effects) {
                target.method_37222(statusEffectInstance, entity);
            }
        }
    }

    public void method_5711(byte status) {
        if (status == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d = (double)(i >> 16 & 0xFF) / 255.0;
                double e = (double)(i >> 8 & 0xFF) / 255.0;
                double f = (double)(i & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.field_6002.method_8406((class_2394)class_2398.field_11226, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), d, e, f);
                }
            }
        } else {
            super.method_5711(status);
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        if (this.target != null && entityHitResult.method_17782().method_5667().equals(this.target.method_5667())) {
            this.hasHitTarget = true;
        }
    }

    private void setTarget() {
        class_1510 dragon;
        class_1309 class_13092;
        if (this.target == null || this.target.method_29504() || (class_13092 = this.target) instanceof class_1510 && (dragon = (class_1510)class_13092).method_6831().method_6864().method_6849() == class_1527.field_7068) {
            class_238 box = new class_238(new class_2338(this.method_19538())).method_1014(20.0).method_1012(0.0, (double)this.field_6002.method_31605(), 0.0);
            List potentialTargets = this.field_6002.method_8390(class_1309.class, box, livingEntity -> true);
            if (potentialTargets.isEmpty()) {
                this.target = null;
                return;
            }
            potentialTargets.removeIf(class_1309::method_29504);
            potentialTargets.removeIf(entity -> !(entity instanceof class_1569));
            potentialTargets.removeIf(entity -> !entity.method_6057((class_1297)this));
            potentialTargets.removeIf(entity -> entity instanceof class_1560);
            potentialTargets.removeIf(entity -> {
                class_1528 boss;
                return entity instanceof class_1528 && (boss = (class_1528)entity).method_6872();
            });
            potentialTargets.removeIf(entity -> {
                if (entity instanceof class_1510) {
                    class_1527 phase = ((class_1510)entity).method_6831().method_6864().method_6849();
                    return phase == class_1527.field_7073 || phase == class_1527.field_7081 || phase == class_1527.field_7072 || phase == class_1527.field_7068;
                }
                return false;
            });
            potentialTargets.removeIf(entity -> {
                class_1657 player;
                return entity instanceof class_1657 && (player = (class_1657)entity).method_5667().equals(Objects.requireNonNull(this.method_24921()).method_5667());
            });
            potentialTargets.removeIf(entity -> {
                class_1657 player;
                return entity instanceof class_1657 && ((player = (class_1657)entity).method_7337() || player.method_7325());
            });
            if (potentialTargets.isEmpty()) {
                this.target = null;
                return;
            }
            this.target = (class_1309)potentialTargets.get(this.field_5974.nextInt(potentialTargets.size()));
        }
    }
}

