/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiSlotMinimap;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.awt.Color;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_350;
import net.minecraft.class_4587;

class GuiSlotWaypoints
extends GuiSlotMinimap {
    private ArrayList<WaypointItem> waypoints;
    private ArrayList<WaypointItem> waypointsFiltered;
    final GuiWaypoints parentGui;
    private String filterString = "";
    final class_2588 ENABLE = new class_2588("minimap.waypoints.enable");
    final class_2588 DISABLE = new class_2588("minimap.waypoints.disable");

    public GuiSlotWaypoints(GuiWaypoints par1GuiWaypoints) {
        super(par1GuiWaypoints.options.game, par1GuiWaypoints.getWidth(), par1GuiWaypoints.getHeight(), 54, par1GuiWaypoints.getHeight() - 90 + 4, 18);
        this.parentGui = par1GuiWaypoints;
        this.waypoints = new ArrayList();
        for (Waypoint pt : this.parentGui.waypointManager.getWaypoints()) {
            if (!pt.inWorld || !pt.inDimension) continue;
            this.waypoints.add(new WaypointItem(this.parentGui, pt));
        }
        this.waypointsFiltered = new ArrayList<WaypointItem>(this.waypoints);
        this.waypointsFiltered.forEach(arg_0 -> ((GuiSlotWaypoints)this).method_25321(arg_0));
    }

    public void method_25313(class_350.class_351 item) {
        this.setSelected((WaypointItem)item);
    }

    public void setSelected(WaypointItem item) {
        super.method_25313((class_350.class_351)item);
        if (this.method_25334() instanceof WaypointItem) {
            class_333.field_2054.method_19788(new class_2588("narrator.select", new Object[]{((WaypointItem)((WaypointItem)this.method_25334())).waypoint.name}).getString());
        }
        this.parentGui.setSelectedWaypoint(item.waypoint);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    protected boolean method_25332(int par1) {
        return this.waypointsFiltered.get(par1).waypoint.equals(this.parentGui.selectedWaypoint);
    }

    protected int method_25317() {
        return this.method_25340() * this.field_22741;
    }

    public void method_25325(class_4587 matrixStack) {
        this.parentGui.method_25420(matrixStack);
    }

    public void drawTexturedModalRect(int xCoord, int yCoord, Sprite textureSprite, int widthIn, int heightIn) {
        class_289 tessellator = class_289.method_1348();
        class_287 vertexbuffer = tessellator.method_1349();
        vertexbuffer.method_1328(7, class_290.field_1585);
        vertexbuffer.method_22912((double)(xCoord + 0), (double)(yCoord + heightIn), 1.0).method_22913(textureSprite.getMinU(), textureSprite.getMaxV()).method_1344();
        vertexbuffer.method_22912((double)(xCoord + widthIn), (double)(yCoord + heightIn), 1.0).method_22913(textureSprite.getMaxU(), textureSprite.getMaxV()).method_1344();
        vertexbuffer.method_22912((double)(xCoord + widthIn), (double)(yCoord + 0), 1.0).method_22913(textureSprite.getMaxU(), textureSprite.getMinV()).method_1344();
        vertexbuffer.method_22912((double)(xCoord + 0), (double)(yCoord + 0), 1.0).method_22913(textureSprite.getMinU(), textureSprite.getMinV()).method_1344();
        tessellator.method_1350();
    }

    protected void sortBy(int sortKey, boolean ascending) {
        final int order = ascending ? 1 : -1;
        this.parentGui.options.getClass();
        if (sortKey == 1) {
            final ArrayList<Waypoint> masterWaypointsList = this.parentGui.waypointManager.getWaypoints();
            Collections.sort(this.waypoints, new Comparator<WaypointItem>(){

                @Override
                public int compare(WaypointItem waypointEntry1, WaypointItem waypointEntry2) {
                    return Double.compare(masterWaypointsList.indexOf(waypointEntry1.waypoint), masterWaypointsList.indexOf(waypointEntry2.waypoint)) * order;
                }
            });
        } else {
            this.parentGui.options.getClass();
            if (sortKey == 3) {
                if (ascending) {
                    Collections.sort(this.waypoints);
                } else {
                    Collections.sort(this.waypoints, Collections.reverseOrder());
                }
            } else {
                this.parentGui.options.getClass();
                if (sortKey == 2) {
                    final Collator collator = I18nUtils.getLocaleAwareCollator();
                    Collections.sort(this.waypoints, new Comparator<WaypointItem>(){

                        @Override
                        public int compare(WaypointItem waypointEntry1, WaypointItem waypointEntry2) {
                            return collator.compare(((WaypointItem)waypointEntry1).waypoint.name, ((WaypointItem)waypointEntry2).waypoint.name) * order;
                        }
                    });
                } else {
                    this.parentGui.options.getClass();
                    if (sortKey == 4) {
                        Collections.sort(this.waypoints, new Comparator<WaypointItem>(){

                            @Override
                            public int compare(WaypointItem waypointEntry1, WaypointItem waypointEntry2) {
                                Waypoint waypoint1 = waypointEntry1.waypoint;
                                Waypoint waypoint2 = waypointEntry2.waypoint;
                                float hue1 = Color.RGBtoHSB((int)(waypoint1.red * 255.0f), (int)(waypoint1.green * 255.0f), (int)(waypoint1.blue * 255.0f), null)[0];
                                float hue2 = Color.RGBtoHSB((int)(waypoint2.red * 255.0f), (int)(waypoint2.green * 255.0f), (int)(waypoint2.blue * 255.0f), null)[0];
                                return Double.compare(hue1, hue2) * order;
                            }
                        });
                    }
                }
            }
        }
        this.updateFilter(this.filterString);
    }

    protected void updateFilter(String filterString) {
        this.method_25339();
        this.filterString = filterString;
        this.waypointsFiltered = new ArrayList<WaypointItem>(this.waypoints);
        Iterator<WaypointItem> iterator = this.waypointsFiltered.iterator();
        while (iterator.hasNext()) {
            Waypoint waypoint = iterator.next().waypoint;
            if (TextUtils.scrubCodes(waypoint.name).toLowerCase().contains(filterString)) continue;
            if (waypoint == this.parentGui.selectedWaypoint) {
                this.parentGui.setSelectedWaypoint(null);
            }
            iterator.remove();
        }
        this.waypointsFiltered.forEach(arg_0 -> ((GuiSlotWaypoints)this).method_25321(arg_0));
    }

    public class WaypointItem
    extends class_350.class_351<WaypointItem>
    implements Comparable<WaypointItem> {
        private final GuiWaypoints parentGui;
        private final Waypoint waypoint;

        protected WaypointItem(GuiWaypoints waypointScreen, Waypoint waypoint) {
            this.parentGui = waypointScreen;
            this.waypoint = waypoint;
        }

        public void method_25343(class_4587 matrixStack, int slotIndex, int slotYPos, int leftEdge, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
            this.parentGui.method_25300(matrixStack, this.parentGui.getFontRenderer(), this.waypoint.name, this.parentGui.getWidth() / 2, slotYPos + 3, this.waypoint.getUnifiedColor());
            int padding = 3;
            if (mouseX >= leftEdge - padding && mouseY >= slotYPos && mouseX <= leftEdge + 215 + padding && mouseY <= slotYPos + entryHeight) {
                class_2588 tooltip;
                if (mouseX >= leftEdge + 215 - 16 - padding && mouseX <= leftEdge + 215 + padding) {
                    tooltip = this.waypoint.enabled ? GuiSlotWaypoints.this.DISABLE : GuiSlotWaypoints.this.ENABLE;
                } else {
                    String tooltipText = "X: " + this.waypoint.getX() + " Z: " + this.waypoint.getZ();
                    if (this.waypoint.getY() > 0) {
                        tooltipText = tooltipText + " Y: " + this.waypoint.getY();
                    }
                    tooltip = new class_2585(tooltipText);
                }
                if (mouseX >= GuiSlotWaypoints.this.field_19088 && mouseX <= GuiSlotWaypoints.this.field_19087 && mouseY >= GuiSlotWaypoints.this.field_19085 && mouseY <= GuiSlotWaypoints.this.field_19086) {
                    GuiWaypoints.setTooltip(GuiSlotWaypoints.this.parentGui, (class_2561)tooltip);
                }
            }
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLUtils.img("textures/mob_effect/" + (this.waypoint.enabled ? "night_vision.png" : "blindness.png"));
            class_332.method_25291((class_4587)matrixStack, (int)(leftEdge + 198), (int)(slotYPos - 2), (int)GuiSlotWaypoints.this.method_25305(), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
            if (this.waypoint == this.parentGui.highlightedWaypoint) {
                int x = leftEdge + 199;
                int y = slotYPos - 1;
                GLShim.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
                TextureAtlas textureAtlas = this.parentGui.waypointManager.getTextureAtlas();
                GLUtils.disp(textureAtlas.method_4624());
                Sprite icon = textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png");
                GuiSlotWaypoints.this.drawTexturedModalRect(x, y, icon, 16, 16);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
            GuiSlotWaypoints.this.setSelected(this);
            int leftEdge = this.parentGui.getWidth() / 2 - 92 - 16;
            int padding = 3;
            int width = 215;
            if (mouseX >= (double)(leftEdge + width - 16 - padding) && mouseX <= (double)(leftEdge + width + padding)) {
                if (GuiSlotWaypoints.this.doubleclick) {
                    this.parentGui.setHighlightedWaypoint();
                }
                this.parentGui.toggleWaypointVisibility();
            } else if (GuiSlotWaypoints.this.doubleclick) {
                this.parentGui.editWaypoint(this.parentGui.selectedWaypoint);
            }
            return true;
        }

        @Override
        public int compareTo(WaypointItem arg0) {
            return this.waypoint.compareTo(arg0.waypoint);
        }
    }
}

