/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class GuiSubworldEdit
extends GuiScreenMinimap
implements BooleanConsumer {
    private class_437 parent;
    private IWaypointManager waypointManager;
    private ArrayList<String> knownSubworldNames;
    private String originalSubworldName = "";
    private String currentSubworldName = "";
    private class_342 subworldNameField;
    private class_4185 doneButton;
    private class_4185 deleteButton;
    private boolean deleteClicked = false;

    public GuiSubworldEdit(class_437 parent, IVoxelMap master, String subworldName) {
        this.parent = parent;
        this.waypointManager = master.getWaypointManager();
        this.originalSubworldName = subworldName;
        this.knownSubworldNames = new ArrayList<String>(this.waypointManager.getKnownSubworldNames());
    }

    public void tick() {
        this.subworldNameField.method_1865();
    }

    public void init() {
        this.getMinecraft().field_1774.method_1462(true);
        this.getButtonList().clear();
        this.subworldNameField = new class_342(this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 0 + 13, 200, 20, "");
        this.setFocused((class_364)this.subworldNameField);
        this.subworldNameField.method_1876(true);
        this.subworldNameField.method_1852(this.originalSubworldName);
        this.addButton((class_339)this.subworldNameField);
        this.doneButton = new class_4185(this.getWidth() / 2 - 155, this.getHeight() / 6 + 168, 150, 20, I18nUtils.getString("gui.done", new Object[0]), null){

            public void onPress() {
                GuiSubworldEdit.this.changeName();
            }
        };
        this.addButton((class_339)this.doneButton);
        this.addButton((class_339)new class_4185(this.getWidth() / 2 + 5, this.getHeight() / 6 + 168, 150, 20, I18nUtils.getString("gui.cancel", new Object[0]), null){

            public void onPress() {
                GuiSubworldEdit.this.getMinecraft().method_1507(GuiSubworldEdit.this.parent);
            }
        });
        int buttonListY = this.getHeight() / 6 + 82 + 6;
        this.deleteButton = new class_4185(this.getWidth() / 2 - 50, buttonListY + 24, 100, 20, I18nUtils.getString("selectServer.delete", new Object[0]), null){

            public void onPress() {
                GuiSubworldEdit.this.delete();
            }
        };
        this.addButton((class_339)this.deleteButton);
        this.doneButton.active = this.isNameAcceptable();
        this.deleteButton.active = this.originalSubworldName.equals(this.subworldNameField.method_1882());
    }

    @Override
    public void removed() {
        this.getMinecraft().field_1774.method_1462(false);
    }

    private void changeName() {
        if (!this.currentSubworldName.equals(this.originalSubworldName)) {
            this.waypointManager.changeSubworldName(this.originalSubworldName, this.currentSubworldName);
        }
        this.getMinecraft().method_1507(this.parent);
    }

    private void delete() {
        this.deleteClicked = true;
        String var4 = I18nUtils.getString("worldmap.subworld.deleteconfirm", new Object[0]);
        class_2588 explanation = new class_2588("selectServer.deleteWarning", new Object[]{this.originalSubworldName});
        String var6 = I18nUtils.getString("selectServer.deleteButton", new Object[0]);
        String var7 = I18nUtils.getString("gui.cancel", new Object[0]);
        class_410 var8 = new class_410((BooleanConsumer)this, (class_2561)new class_2585(var4), (class_2561)explanation, var6, var7);
        this.getMinecraft().method_1507((class_437)var8);
    }

    public void accept(boolean par1) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (par1) {
                this.waypointManager.deleteSubworld(this.originalSubworldName);
            }
            this.getMinecraft().method_1507(this.parent);
        }
    }

    public boolean keyPressed(int keysm, int scancode, int b) {
        boolean OK = super.keyPressed(keysm, scancode, b);
        boolean acceptable = this.isNameAcceptable();
        this.doneButton.active = this.isNameAcceptable();
        this.deleteButton.active = this.originalSubworldName.equals(this.subworldNameField.method_1882());
        if ((keysm == 257 || keysm == 335) && acceptable) {
            this.changeName();
        }
        return OK;
    }

    public boolean charTyped(char character, int keycode) {
        boolean OK = super.charTyped(character, keycode);
        boolean acceptable = this.isNameAcceptable();
        this.doneButton.active = this.isNameAcceptable();
        this.deleteButton.active = this.originalSubworldName.equals(this.subworldNameField.method_1882());
        if (character == '\r' && acceptable) {
            this.changeName();
        }
        return OK;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int par3) {
        this.subworldNameField.mouseClicked(mouseX, mouseY, par3);
        return super.mouseClicked(mouseX, mouseY, par3);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.drawMap();
        this.renderBackground();
        this.drawCenteredString(this.getFontRenderer(), I18nUtils.getString("worldmap.subworld.edit", new Object[0]), this.getWidth() / 2, 20, 0xFFFFFF);
        this.drawString(this.getFontRenderer(), I18nUtils.getString("worldmap.subworld.name", new Object[0]), this.getWidth() / 2 - 100, this.getHeight() / 6 + 0, 0xA0A0A0);
        this.subworldNameField.render(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
    }

    private boolean isNameAcceptable() {
        boolean acceptable = true;
        this.currentSubworldName = this.subworldNameField.method_1882();
        acceptable = acceptable && this.currentSubworldName.length() > 0;
        acceptable = acceptable && (this.currentSubworldName.equals(this.originalSubworldName) || !this.knownSubworldNames.contains(this.currentSubworldName));
        return acceptable;
    }
}

