/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiSubworldEdit;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_299;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_743;
import net.minecraft.class_746;

public class GuiSubworldsSelect
extends GuiScreenMinimap
implements BooleanConsumer {
    private String title = "VoxelMap - Multiworld Selection";
    private String select = "Which world are you in?";
    private boolean multiworld = false;
    private class_4185 cancelBtn;
    private class_342 newNameField;
    private boolean newWorld = false;
    private float yaw;
    private int thirdPersonViewOrig;
    private class_4185[] selectButtons;
    private class_4185[] editButtons;
    private String[] worlds;
    private class_437 parent;
    class_746 thePlayer;
    class_746 camera;
    private IVoxelMap master;
    private IWaypointManager waypointManager;

    public GuiSubworldsSelect(class_437 parent, IVoxelMap master) {
        this.minecraft = class_310.method_1551();
        this.parent = parent;
        this.thePlayer = this.getMinecraft().field_1724;
        this.camera = new class_746(this.getMinecraft(), this.getMinecraft().field_1687, this.getMinecraft().method_1562(), this.thePlayer.method_3143(), new class_299(null));
        this.camera.field_3913 = new class_743(this.getMinecraft().field_1690);
        this.camera.method_5808(this.thePlayer.method_23317(), this.thePlayer.method_23318() - this.thePlayer.method_5678(), this.thePlayer.method_23321(), this.thePlayer.field_6031, 0.0f);
        this.yaw = this.thePlayer.field_6031;
        this.thirdPersonViewOrig = this.getMinecraft().field_1690.field_1850;
        this.master = master;
        this.waypointManager = master.getWaypointManager();
    }

    public void init() {
        ArrayList<String> knownSubworldNames = new ArrayList<String>(this.waypointManager.getKnownSubworldNames());
        if (!(this.multiworld || this.waypointManager.isMultiworld() || this.getMinecraft().method_1589())) {
            class_410 var8 = new class_410((BooleanConsumer)this, (class_2561)new class_2588("worldmap.multiworld.isthismultiworld", new Object[0]), (class_2561)new class_2588("worldmap.multiworld.explanation", new Object[0]), I18nUtils.getString("gui.yes", new Object[0]), I18nUtils.getString("gui.no", new Object[0]));
            this.getMinecraft().method_1507((class_437)var8);
        } else {
            this.getMinecraft().field_1690.field_1850 = 0;
            this.getMinecraft().method_1504((class_1297)this.camera);
        }
        this.title = I18nUtils.getString("worldmap.multiworld.title", new Object[0]);
        this.select = I18nUtils.getString("worldmap.multiworld.select", new Object[0]);
        this.getButtonList().clear();
        int centerX = this.width / 2;
        int buttonsPerRow = this.width / 150;
        if (buttonsPerRow == 0) {
            buttonsPerRow = 1;
        }
        int buttonWidth = this.width / buttonsPerRow - 5;
        int xSpacing = (this.width - buttonsPerRow * buttonWidth) / 2;
        this.cancelBtn = new class_4185(centerX - 100, this.height - 30, 200, 20, I18nUtils.getString("gui.cancel", new Object[0]), null){

            public void onPress() {
                GuiSubworldsSelect.this.actionPerformed(this, 0);
            }
        };
        this.addButton((class_339)this.cancelBtn);
        final Collator collator = I18nUtils.getLocaleAwareCollator();
        Collections.sort(knownSubworldNames, new Comparator<String>(){

            @Override
            public int compare(String name1, String name2) {
                return -collator.compare(name1, name2);
            }
        });
        int numKnownSubworlds = knownSubworldNames.size();
        int completeRows = (int)Math.floor((float)(numKnownSubworlds + 1) / (float)buttonsPerRow);
        int lastRowShiftBy = (int)(Math.ceil((float)(numKnownSubworlds + 1) / (float)buttonsPerRow) * (double)buttonsPerRow - (double)(numKnownSubworlds + 1));
        this.worlds = new String[numKnownSubworlds];
        this.selectButtons = new class_4185[numKnownSubworlds + 1];
        this.editButtons = new class_4185[numKnownSubworlds + 1];
        for (int t = 0; t < numKnownSubworlds; ++t) {
            int shiftBy = 1;
            if (t / buttonsPerRow >= completeRows) {
                shiftBy = lastRowShiftBy + 1;
            }
            this.worlds[t] = knownSubworldNames.get(t);
            final int tt = t;
            this.selectButtons[t] = new class_4185((buttonsPerRow - shiftBy - t % buttonsPerRow) * buttonWidth + xSpacing, this.height - 60 - t / buttonsPerRow * 21, buttonWidth - 32, 20, this.worlds[t], null){

                public void onPress() {
                    GuiSubworldsSelect.this.actionPerformed(this, tt + 1);
                }
            };
            this.editButtons[t] = new class_4185((buttonsPerRow - shiftBy - t % buttonsPerRow) * buttonWidth + xSpacing + buttonWidth - 32, this.height - 60 - t / buttonsPerRow * 21, 30, 20, "\u2692", null){

                public void onPress() {
                    GuiSubworldsSelect.this.actionPerformed(this, -(tt + 1));
                }
            };
            this.addButton((class_339)this.selectButtons[t]);
            this.addButton((class_339)this.editButtons[t]);
        }
        final int numButtons = this.selectButtons.length - 1;
        if (!this.newWorld) {
            this.selectButtons[numButtons] = new class_4185((buttonsPerRow - 1 - lastRowShiftBy - numButtons % buttonsPerRow) * buttonWidth + xSpacing, this.height - 60 - numButtons / buttonsPerRow * 21, buttonWidth - 2, 20, "< " + I18nUtils.getString("worldmap.multiworld.newname", new Object[0]) + " >", null){

                public void onPress() {
                    GuiSubworldsSelect.this.actionPerformed(this, numButtons + 1);
                }
            };
            this.addButton((class_339)this.selectButtons[numButtons]);
        }
        this.newNameField = new class_342(this.getFontRenderer(), (buttonsPerRow - 1 - lastRowShiftBy - numButtons % buttonsPerRow) * buttonWidth + xSpacing + 1, this.height - 60 - numButtons / buttonsPerRow * 21 + 1, buttonWidth - 4, 18, "");
    }

    protected void actionPerformed(class_4185 button, int id) {
        if (button.active) {
            this.newWorld = false;
            if (id == this.worlds.length + 1) {
                this.newWorld = true;
                this.addButton((class_339)this.selectButtons[this.worlds.length]);
                this.newNameField.method_1876(true);
            } else if (id == 0) {
                this.getMinecraft().method_1507((class_437)null);
            } else if (id > 0) {
                this.worldSelected(this.worlds[id - 1]);
            } else {
                this.editWorld(this.worlds[-id - 1]);
            }
        }
    }

    public void accept(boolean par1) {
        if (!par1) {
            this.getMinecraft().method_1507(this.parent);
        } else {
            this.multiworld = true;
            this.getMinecraft().method_1507((class_437)this);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.newWorld) {
            this.newNameField.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keysm, int scancode, int b) {
        if (this.newNameField.isFocused()) {
            String newName;
            this.newNameField.keyPressed(keysm, scancode, b);
            if ((keysm == 257 || keysm == 335) && this.newNameField.isFocused() && (newName = this.newNameField.method_1882()) != null && !newName.isEmpty()) {
                this.worldSelected(newName);
            }
        }
        return super.keyPressed(keysm, scancode, b);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.newNameField.isFocused()) {
            String newName;
            this.newNameField.charTyped(typedChar, keyCode);
            if (keyCode == 28 && (newName = this.newNameField.method_1882()) != null && !newName.isEmpty()) {
                this.worldSelected(newName);
            }
        }
        return super.charTyped(typedChar, keyCode);
    }

    public void tick() {
        this.newNameField.method_1865();
        super.tick();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int titleStringWidth = this.getFontRenderer().method_1727(this.title);
        titleStringWidth = Math.max(titleStringWidth, this.getFontRenderer().method_1727(this.select));
        GuiSubworldsSelect.fill((int)(this.width / 2 - titleStringWidth / 2 - 5), (int)0, (int)(this.width / 2 + titleStringWidth / 2 + 5), (int)27, (int)-1073741824);
        this.drawCenteredString(this.getFontRenderer(), this.title, this.width / 2, 5, 0xFFFFFF);
        this.drawCenteredString(this.getFontRenderer(), this.select, this.width / 2, 15, 0xFF0000);
        this.camera.field_5965 = 0.0f;
        this.camera.field_6004 = 0.0f;
        this.camera.field_5982 = this.camera.field_6031 = this.yaw;
        float var4 = 0.475f;
        this.camera.field_5971 = this.camera.field_6036 = this.thePlayer.method_23318();
        this.camera.field_6038 = this.camera.field_6014 = this.thePlayer.method_23317() - (double)var4 * Math.sin((double)this.yaw / 180.0 * Math.PI);
        this.camera.field_5989 = this.camera.field_5969 = this.thePlayer.method_23321() + (double)var4 * Math.cos((double)this.yaw / 180.0 * Math.PI);
        this.camera.method_23327(this.camera.field_6014, this.camera.field_6036, this.camera.field_5969);
        float var5 = 1.0f;
        this.yaw = (float)((double)this.yaw + (double)var5 * (1.0 + (double)0.7f * Math.cos((double)(this.yaw + 45.0f) / 45.0 * Math.PI)));
        super.render(mouseX, mouseY, partialTicks);
        if (this.newWorld) {
            this.newNameField.render(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void removed() {
        super.removed();
        this.getMinecraft().field_1690.field_1850 = this.thirdPersonViewOrig;
        this.getMinecraft().method_1504((class_1297)this.thePlayer);
    }

    private void worldSelected(String selectedSubworldName) {
        this.waypointManager.setSubworldName(selectedSubworldName, false);
        if (this.parent == null) {
            this.getMinecraft().method_1507((class_437)null);
        } else {
            this.getMinecraft().method_1507(this.parent);
        }
    }

    private void editWorld(String subworldNameToEdit) {
        this.getMinecraft().method_1507((class_437)new GuiSubworldEdit(this, this.master, subworldNameToEdit));
    }
}

