/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.model;

import com.pepper.faunify.entity.MouseEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class MouseModel
extends DefaultedEntityGeoModel<MouseEntity> {
    public MouseModel() {
        super(new ResourceLocation("faunify", "mouse"), true);
    }

    public ResourceLocation getAnimationResource(MouseEntity object) {
        return new ResourceLocation("faunify", "animations/mouse.animation.json");
    }

    public void setCustomAnimations(MouseEntity entity, long uniqueID, AnimationState<MouseEntity> animationState) {
        if (!this.turnsHead) {
            return;
        }
        CoreGeoBone head = this.getAnimationProcessor().getBone("body");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
        CoreGeoBone neck = this.getAnimationProcessor().getBone("body_rotation");
        boolean moving = animationState.isMoving();
        if (neck != null && head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            float pitch = entityData.headPitch();
            neck.setRotX(Math.min(20.0f, pitch) * ((float)Math.PI / 180));
            if (pitch > 20.0f && !moving) {
                head.setRotX((pitch - 30.0f) * ((float)Math.PI / 180));
            }
            neck.setRotZ(entityData.netHeadYaw() * ((float)Math.PI / 180) * -0.5f);
        }
    }
}

