/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.pepper.faunify.entity.client.model.QuillModel;
import com.pepper.faunify.entity.projectile.QuillEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class QuillEntityRenderer
extends GeoEntityRenderer<QuillEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("faunify", "textures/entity/quill.png");

    public QuillEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new QuillModel());
        this.f_114477_ = 0.1f;
    }

    public ResourceLocation getTextureLocation(QuillEntity entity) {
        return TEXTURE;
    }

    public void render(QuillEntity entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
        stack.m_85836_();
        float yRot = Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_());
        float xRot = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        stack.m_252781_(Axis.f_252436_.m_252977_(yRot));
        stack.m_252781_(Axis.f_252529_.m_252977_(xRot));
        if (entity.isStuckInEntity()) {
            this.renderStuckQuill(entity, stack, bufferSource, packedLight, entityYaw, partialTicks);
        } else {
            super.m_7392_((Entity)entity, entityYaw, partialTicks, stack, bufferSource, packedLight);
        }
        stack.m_85849_();
    }

    public void preRender(PoseStack stack, QuillEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(stack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private void renderStuckQuill(QuillEntity entity, PoseStack stack, MultiBufferSource bufferSource, int packedLight, float entityYaw, float partialTicks) {
        this.renderModel(entity, stack, bufferSource, packedLight);
    }

    protected void renderModel(QuillEntity entity, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_((Entity)entity, entity.m_146908_(), entity.m_146909_(), stack, bufferSource, packedLight);
    }
}

